/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.utils;

import com.google.common.collect.Sets;
import com.jeeplus.flowable.model.Flow;
import com.jeeplus.flowable.utils.TimeUtils;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.json.util.JSONUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.ComplexGateway;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.repository.Model;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntity;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowableUtils {
    public static String getFormUrl(String formKey, Flow flow) throws Exception {
        StringBuilder formUrl = new StringBuilder();
        formUrl.append(formKey).append(formUrl.indexOf("?") == -1 ? "?" : "&");
        formUrl.append("act.taskId=").append(flow.getTaskId() != null ? flow.getTaskId() : "");
        formUrl.append("&act.taskName=").append(flow.getTaskName() != null ? URLEncoder.encode(flow.getTaskName(), "UTF-8") : "");
        formUrl.append("&act.taskDefKey=").append(flow.getTaskDefKey() != null ? flow.getTaskDefKey() : "");
        formUrl.append("&act.procInsId=").append(flow.getProcInsId() != null ? flow.getProcInsId() : "");
        formUrl.append("&act.procDefId=").append(flow.getProcDefId() != null ? flow.getProcDefId() : "");
        formUrl.append("&id=").append(flow.getBusinessId() != null ? flow.getBusinessId() : "");
        return formUrl.toString();
    }

    public static UserEntity toFlowableUser(UserDTO user) {
        if (user == null) {
            return null;
        }
        UserEntityImpl userEntity = new UserEntityImpl();
        userEntity.setId(user.getId());
        userEntity.setFirstName(user.getName());
        userEntity.setLastName("");
        userEntity.setPassword(user.getPassword());
        userEntity.setEmail(user.getEmail());
        userEntity.setRevision(1);
        return userEntity;
    }

    public static GroupEntity toFlowableGroup(RoleDTO role) {
        if (role == null) {
            return null;
        }
        GroupEntityImpl groupEntity = new GroupEntityImpl();
        groupEntity.setId(role.getEnName());
        groupEntity.setName(role.getName());
        groupEntity.setRevision(1);
        return groupEntity;
    }

    public static String toTimeString(long time) {
        TimeUtils t = new TimeUtils(time);
        int day = t.get(3);
        int hour = t.get(2);
        int minute = t.get(1);
        int second = t.get(0);
        StringBuilder sb = new StringBuilder();
        if (day > 0) {
            sb.append(day).append("\u5929");
        }
        if (hour > 0) {
            sb.append(hour).append("\u65f6");
        }
        if (minute > 0) {
            sb.append(minute).append("\u5206");
        }
        if (second > 0) {
            sb.append(second).append("\u79d2");
        }
        return sb.toString();
    }

    public static Model buildModel(Model model, String categoryId, String name, String key, String description) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("category", categoryId);
        map.put("key", key);
        map.put("name", name);
        map.put("revision", 1);
        map.put("description", description);
        model.setMetaInfo(JSONUtils.valueToString(map));
        model.setKey(key);
        model.setName(name);
        model.setCategory(categoryId);
        model.setKey(key);
        return model;
    }

    public static boolean isReachable(Process process, FlowNode sourceElement, FlowNode targetElement) {
        return FlowableUtils.isReachable((Process)process, (FlowNode)sourceElement, (FlowNode)targetElement, (Set)Sets.newHashSet());
    }

    public static boolean isReachable(Process process, FlowNode sourceElement, FlowNode targetElement, Set<String> visitedElements) {
        if (sourceElement instanceof StartEvent && FlowableUtils.isInEventSubprocess((FlowNode)sourceElement)) {
            return false;
        }
        if (sourceElement.getOutgoingFlows().size() == 0) {
            visitedElements.add(sourceElement.getId());
            FlowElementsContainer parentElement = process.findParent((FlowElement)sourceElement);
            if (parentElement instanceof SubProcess) {
                sourceElement = (SubProcess)parentElement;
                if (((SubProcess)sourceElement).getFlowElement(targetElement.getId()) != null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (sourceElement.getId().equals(targetElement.getId())) {
            return true;
        }
        visitedElements.add(sourceElement.getId());
        if (sourceElement instanceof SubProcess && ((SubProcess)sourceElement).getFlowElement(targetElement.getId()) != null) {
            return true;
        }
        List sequenceFlows = sourceElement.getOutgoingFlows();
        if (sequenceFlows != null && sequenceFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                boolean reachable;
                String targetRef = sequenceFlow.getTargetRef();
                FlowNode sequenceFlowTarget = (FlowNode)process.getFlowElement(targetRef, true);
                if (sequenceFlowTarget == null || visitedElements.contains(sequenceFlowTarget.getId()) || !(reachable = FlowableUtils.isReachable((Process)process, (FlowNode)sequenceFlowTarget, (FlowNode)targetElement, visitedElements))) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isInEventSubprocess(FlowNode flowNode) {
        FlowElementsContainer flowElementsContainer = flowNode.getParentContainer();
        while (flowElementsContainer != null) {
            if (flowElementsContainer instanceof EventSubProcess) {
                return true;
            }
            if (flowElementsContainer instanceof FlowElement) {
                flowElementsContainer = ((FlowElement)flowElementsContainer).getParentContainer();
                continue;
            }
            flowElementsContainer = null;
        }
        return false;
    }

    public static String[] getSourceAndTargetRealActivityId(FlowNode sourceFlowElement, FlowNode targetFlowElement) {
        List targetParentProcesss;
        String sourceRealActivityId = sourceFlowElement.getId();
        String targetRealActivityId = targetFlowElement.getId();
        List sourceParentProcesss = FlowableUtils.getParentProcessIds((FlowNode)sourceFlowElement);
        int diffParentLevel = FlowableUtils.getDiffLevel((List)sourceParentProcesss, (List)(targetParentProcesss = FlowableUtils.getParentProcessIds((FlowNode)targetFlowElement)));
        if (diffParentLevel != -1) {
            sourceRealActivityId = sourceParentProcesss.size() == diffParentLevel ? sourceRealActivityId : (String)sourceParentProcesss.get(diffParentLevel);
            targetRealActivityId = targetParentProcesss.size() == diffParentLevel ? targetRealActivityId : (String)targetParentProcesss.get(diffParentLevel);
        }
        return new String[]{sourceRealActivityId, targetRealActivityId};
    }

    public static List<String> getParentProcessIds(FlowNode flowNode) {
        ArrayList<String> result = new ArrayList<String>();
        FlowElementsContainer flowElementsContainer = flowNode.getParentContainer();
        while (flowElementsContainer != null) {
            SubProcess flowElement;
            if (flowElementsContainer instanceof SubProcess) {
                flowElement = (SubProcess)flowElementsContainer;
                result.add(flowElement.getId());
                flowElementsContainer = flowElement.getParentContainer();
                continue;
            }
            if (!(flowElementsContainer instanceof Process)) continue;
            flowElement = (Process)flowElementsContainer;
            result.add(flowElement.getId());
            flowElementsContainer = null;
        }
        Collections.reverse(result);
        return result;
    }

    public static Integer getDiffLevel(List<String> sourceList, List<String> targetList) {
        if (sourceList == null || sourceList.isEmpty() || targetList == null || targetList.isEmpty()) {
            throw new FlowableException("sourceList and targetList cannot be empty");
        }
        if (sourceList.size() == 1 && targetList.size() == 1) {
            if (!sourceList.get(0).equals(targetList.get(0))) {
                return 0;
            }
            return -1;
        }
        int minSize = sourceList.size() < targetList.size() ? sourceList.size() : targetList.size();
        Integer targetLevel = null;
        for (int i = 0; i < minSize; ++i) {
            if (sourceList.get(i).equals(targetList.get(i))) continue;
            targetLevel = i;
            break;
        }
        if (targetLevel == null) {
            targetLevel = sourceList.size() == targetList.size() ? Integer.valueOf(-1) : Integer.valueOf(minSize);
        }
        return targetLevel;
    }

    public static Map<String, Set<String>> getSpecialGatewayElements(FlowElementsContainer container) {
        return FlowableUtils.getSpecialGatewayElements((FlowElementsContainer)container, null);
    }

    public static Map<String, Set<String>> getSpecialGatewayElements(FlowElementsContainer container, Map<String, Set<String>> specialGatewayElements) {
        if (specialGatewayElements == null) {
            specialGatewayElements = new HashMap<String, Set<String>>(16);
        }
        Collection flowelements = container.getFlowElements();
        for (FlowElement flowElement : flowelements) {
            boolean isBeginSpecialGateway;
            boolean bl = isBeginSpecialGateway = flowElement.getId().endsWith("_begin") && (flowElement instanceof ParallelGateway || flowElement instanceof InclusiveGateway || flowElement instanceof ComplexGateway);
            if (isBeginSpecialGateway) {
                String gatewayBeginRealId = flowElement.getId();
                String gatewayId = gatewayBeginRealId.substring(0, gatewayBeginRealId.length() - 6);
                Set gatewayIdContainFlowelements = specialGatewayElements.computeIfAbsent(gatewayId, k -> new HashSet());
                FlowableUtils.findElementsBetweenSpecialGateway((FlowElement)flowElement, (String)(gatewayId + "_end"), (Set)gatewayIdContainFlowelements);
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            FlowableUtils.getSpecialGatewayElements((FlowElementsContainer)((SubProcess)flowElement), specialGatewayElements);
        }
        LinkedHashMap<String, Set<String>> specialGatewayNodesSort = new LinkedHashMap<String, Set<String>>();
        specialGatewayElements.entrySet().stream().sorted((o1, o2) -> ((Set)o2.getValue()).size() - ((Set)o1.getValue()).size()).forEach(entry -> {
            Set cfr_ignored_0 = (Set)specialGatewayNodesSort.put((String)entry.getKey(), (Set<String>)entry.getValue());
        });
        return specialGatewayNodesSort;
    }

    public static void findElementsBetweenSpecialGateway(FlowElement specialGatewayBegin, String specialGatewayEndId, Set<String> elements) {
        elements.add(specialGatewayBegin.getId());
        List sequenceFlows = ((FlowNode)specialGatewayBegin).getOutgoingFlows();
        if (sequenceFlows != null && sequenceFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
                String targetFlowElementId = targetFlowElement.getId();
                elements.add(specialGatewayEndId);
                if (targetFlowElementId.equals(specialGatewayEndId)) continue;
                FlowableUtils.findElementsBetweenSpecialGateway((FlowElement)targetFlowElement, (String)specialGatewayEndId, elements);
            }
        }
    }

    public static Set<String> getParentExecutionIdsByActivityId(List<ExecutionEntity> executions, String activityId) {
        List activityIdExecutions = executions.stream().filter(e -> activityId.equals(e.getActivityId())).collect(Collectors.toList());
        if (activityIdExecutions.isEmpty()) {
            throw new FlowableException("Active execution could not be found with activity id " + activityId);
        }
        ExecutionEntity miExecution = null;
        boolean isInsideMultiInstance = false;
        for (ExecutionEntity possibleMiExecution : activityIdExecutions) {
            if (possibleMiExecution.isMultiInstanceRoot()) {
                miExecution = possibleMiExecution;
                isInsideMultiInstance = true;
                break;
            }
            if (!FlowableUtils.isExecutionInsideMultiInstance((ExecutionEntity)possibleMiExecution)) continue;
            isInsideMultiInstance = true;
        }
        HashSet<String> parentExecutionIds = new HashSet<String>();
        if (isInsideMultiInstance) {
            Stream<Object> executionEntitiesStream = activityIdExecutions.stream();
            if (miExecution != null) {
                executionEntitiesStream = executionEntitiesStream.filter(DelegateExecution::isMultiInstanceRoot);
            }
            executionEntitiesStream.forEach(childExecution -> parentExecutionIds.add(childExecution.getParentId()));
        } else {
            ExecutionEntity execution = (ExecutionEntity)activityIdExecutions.iterator().next();
            parentExecutionIds.add(execution.getParentId());
        }
        return parentExecutionIds;
    }

    public static boolean isExecutionInsideMultiInstance(ExecutionEntity execution) {
        return FlowableUtils.getFlowElementMultiInstanceParentId((FlowElement)execution.getCurrentFlowElement()).isPresent();
    }

    public static Optional<String> getFlowElementMultiInstanceParentId(FlowElement flowElement) {
        FlowElementsContainer parentContainer = flowElement.getParentContainer();
        while (parentContainer instanceof Activity) {
            if (FlowableUtils.isFlowElementMultiInstance((FlowElement)((Activity)parentContainer))) {
                return Optional.of(((Activity)parentContainer).getId());
            }
            parentContainer = ((Activity)parentContainer).getParentContainer();
        }
        return Optional.empty();
    }

    public static boolean isFlowElementMultiInstance(FlowElement flowElement) {
        if (flowElement instanceof Activity) {
            return ((Activity)flowElement).getLoopCharacteristics() != null;
        }
        return false;
    }

    public static String getParentExecutionIdFromParentIds(ExecutionEntity execution, Set<String> parentExecutionIds) {
        String realParentExecutionId = null;
        for (ExecutionEntity taskParentExecution = execution.getParent(); taskParentExecution != null; taskParentExecution = taskParentExecution.getParent()) {
            if (!parentExecutionIds.contains(taskParentExecution.getId())) continue;
            realParentExecutionId = taskParentExecution.getId();
            break;
        }
        if (realParentExecutionId == null || realParentExecutionId.length() == 0) {
            throw new FlowableException("Parent execution could not be found with executionId id " + execution.getId());
        }
        return realParentExecutionId;
    }
}

