/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service.ext;

import com.jeeplus.flowable.service.ext.iml.FlowGroupQueryImpl;
import com.jeeplus.flowable.service.ext.iml.FlowUserQueryImpl;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.PrivilegeMapping;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.IdmIdentityServiceImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;

public class FlowIdentityServiceImpl
extends IdmIdentityServiceImpl {
    public FlowIdentityServiceImpl(IdmEngineConfiguration idmEngineConfiguration) {
        super(idmEngineConfiguration);
    }

    public UserQuery createUserQuery() {
        return new FlowUserQueryImpl();
    }

    public GroupQuery createGroupQuery() {
        return new FlowGroupQueryImpl();
    }

    public boolean checkPassword(String userId, String password) {
        return this.executeCheckPassword(userId, password);
    }

    public List<Group> getGroupsWithPrivilege(String name) {
        ArrayList<Group> groups = new ArrayList<Group>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getGroupId() == null) continue;
            GroupEntityImpl group = new GroupEntityImpl();
            group.setId(privilegeMapping.getGroupId());
            group.setName(privilegeMapping.getGroupId());
            groups.add((Group)group);
        }
        return groups;
    }

    public List<User> getUsersWithPrivilege(String name) {
        ArrayList<User> users = new ArrayList<User>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getUserId() == null) continue;
            UserEntityImpl user = new UserEntityImpl();
            user.setId(privilegeMapping.getUserId());
            user.setLastName(privilegeMapping.getUserId());
            users.add((User)user);
        }
        return users;
    }

    public User newUser(String userId) {
        throw new FlowableException("LDAP identity service doesn't support creating a new user");
    }

    public void saveUser(User user) {
        throw new FlowableException("LDAP identity service doesn't support saving an user");
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new FlowableException("LDAP identity service doesn't support native querying");
    }

    public void deleteUser(String userId) {
        throw new FlowableException("LDAP identity service doesn't support deleting an user");
    }

    public Group newGroup(String groupId) {
        throw new FlowableException("LDAP identity service doesn't support creating a new group");
    }

    public NativeGroupQuery createNativeGroupQuery() {
        throw new FlowableException("LDAP identity service doesn't support native querying");
    }

    public void saveGroup(Group group) {
        throw new FlowableException("LDAP identity service doesn't support saving a group");
    }

    public void deleteGroup(String groupId) {
        throw new FlowableException("LDAP identity service doesn't support deleting a group");
    }

    protected boolean executeCheckPassword(String userId, String password) {
        return true;
    }
}

