/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.common.utils.Collections3;
import com.jeeplus.flowable.common.cmd.BackUserTaskCmd;
import com.jeeplus.flowable.mapper.FlowMapper;
import com.jeeplus.flowable.model.Flow;
import com.jeeplus.flowable.model.TaskComment;
import com.jeeplus.flowable.service.FlowProcessService;
import com.jeeplus.flowable.service.FlowTaskService;
import com.jeeplus.flowable.service.converter.json.FlowModelService;
import com.jeeplus.flowable.utils.FlowableUtils;
import com.jeeplus.flowable.utils.ProcessDefCache;
import com.jeeplus.flowable.vo.ActionType;
import com.jeeplus.flowable.vo.HisTaskVo;
import com.jeeplus.flowable.vo.ProcessStatus;
import com.jeeplus.flowable.vo.ProcessVo;
import com.jeeplus.flowable.vo.TaskVo;
import com.jeeplus.sys.feign.ITenantApi;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ActivityInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.flowable.variable.api.history.HistoricVariableInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowTaskService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskService.class);
    @Autowired
    private FlowMapper flowMapper;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FormService formService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private FlowModelService flowModelService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private FlowProcessService flowProcessService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ITenantApi tenantApi;

    public Page<ProcessVo> todoList(Page<ProcessVo> page, Flow flow) {
        List todoList;
        ArrayList result = new ArrayList();
        String userId = this.userApi.getByToken(TokenProvider.getCurrentToken()).getId();
        TaskQuery todoTaskQuery = (TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskCandidateOrAssigned(userId).active().includeProcessVariables()).orderByTaskCreateTime()).desc();
        if (StrUtil.isNotBlank((CharSequence)flow.getProcDefKey())) {
            todoTaskQuery.processDefinitionKey(flow.getProcDefKey());
        }
        if (flow.getBeginDate() != null) {
            todoTaskQuery.taskCreatedAfter(flow.getBeginDate());
        }
        if (flow.getEndDate() != null) {
            todoTaskQuery.taskCreatedBefore(flow.getEndDate());
        }
        if (StrUtil.isNotBlank((CharSequence)flow.getTitle())) {
            todoTaskQuery.processVariableValueLike("title", "%" + flow.getTitle() + "%");
        }
        long total = todoTaskQuery.count();
        page.setTotal(total);
        if (page.getSize() == -1L) {
            todoList = todoTaskQuery.list();
        } else {
            int start = (int)((page.getCurrent() - 1L) * page.getSize());
            int size = (int)page.getSize();
            todoList = todoTaskQuery.listPage(start, size);
        }
        ArrayList records = Lists.newArrayList();
        for (Task task : todoList) {
            Process process = ((RepositoryService)SpringUtil.getBean(RepositoryService.class)).getBpmnModel(task.getProcessDefinitionId()).getMainProcess();
            ProcessVo processVo = new ProcessVo();
            TaskVo taskVo = new TaskVo((TaskInfo)task);
            taskVo.setProcessDefKey(process.getId());
            processVo.setTask(taskVo);
            processVo.setVars(task.getProcessVariables());
            processVo.setProcessDefinitionName(ProcessDefCache.get((String)task.getProcessDefinitionId()).getName());
            processVo.setVersion(ProcessDefCache.get((String)task.getProcessDefinitionId()).getVersion());
            processVo.setStatus("todo");
            records.add(processVo);
        }
        page.setRecords((List)records);
        return page;
    }

    public Page<HisTaskVo> historicList(Page<HisTaskVo> page, Flow act) {
        List histList;
        String userId = this.userApi.getByToken(TokenProvider.getCurrentToken()).getId();
        HistoricTaskInstanceQuery histTaskQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(userId)).finished().includeProcessVariables()).orderByHistoricTaskInstanceEndTime().desc();
        if (StrUtil.isNotBlank((CharSequence)act.getProcDefKey())) {
            histTaskQuery.processDefinitionKey(act.getProcDefKey());
        }
        if (act.getBeginDate() != null) {
            histTaskQuery.taskCompletedAfter(act.getBeginDate());
        }
        if (act.getEndDate() != null) {
            histTaskQuery.taskCompletedBefore(act.getEndDate());
        }
        if (act.getTitle() != null) {
            histTaskQuery.processVariableValueLike("title", "%" + act.getTitle() + "%");
        }
        page.setTotal(histTaskQuery.count());
        if (page.getSize() == -1L) {
            histList = histTaskQuery.list();
        } else {
            int start = (int)((page.getCurrent() - 1L) * page.getSize());
            int size = (int)page.getSize();
            histList = histTaskQuery.listPage(start, size);
        }
        ArrayList records = Lists.newArrayList();
        for (HistoricTaskInstance histTask : histList) {
            List commentList;
            HisTaskVo hisTaskVo = new HisTaskVo(histTask);
            hisTaskVo.setProcessDefinitionName(ProcessDefCache.get((String)histTask.getProcessDefinitionId()).getName());
            hisTaskVo.setBack(this.isBack(histTask));
            List currentTaskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(histTask.getProcessInstanceId())).list();
            if (currentTaskList.size() > 0) {
                TaskVo currentTaskVo = new TaskVo((TaskInfo)currentTaskList.get(0));
                hisTaskVo.setCurrentTask(currentTaskVo);
            }
            if ((commentList = this.getTaskComments(histTask.getId())).size() > 0) {
                TaskComment comment = (TaskComment)commentList.get(commentList.size() - 1);
                hisTaskVo.setComment(comment.getMessage());
                hisTaskVo.setLevel(comment.getLevel());
                hisTaskVo.setType(comment.getType());
                hisTaskVo.setStatus(comment.getStatus());
            }
            records.add(hisTaskVo);
        }
        page.setRecords((List)records);
        return page;
    }

    public List<Flow> historicTaskList(String procInsId) throws Exception {
        ArrayList actList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        List historicActivityInstances2 = ((HistoricActivityInstanceQuery)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procInsId).orderByHistoricActivityInstanceStartTime().asc()).orderByHistoricActivityInstanceEndTime().asc()).list();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances2) {
            if (historicActivityInstance.getEndTime() == null) continue;
            list.add(historicActivityInstance);
        }
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances2) {
            if (historicActivityInstance.getEndTime() != null) continue;
            list.add(historicActivityInstance);
        }
        for (int i = 0; i < list.size(); ++i) {
            HistoricActivityInstance histIns = (HistoricActivityInstance)list.get(i);
            if (!(StrUtil.isNotBlank((CharSequence)histIns.getAssignee()) && ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(histIns.getTaskId())).count() != 0L || "userTask".equals(histIns.getActivityType()) && histIns.getEndTime() == null || "startEvent".equals(histIns.getActivityType())) && !"endEvent".equals(histIns.getActivityType())) continue;
            Flow e = this.queryTaskState(histIns);
            actList.add(e);
        }
        return actList;
    }

    public String getFormKey(String procDefId, String taskDefKey) {
        String formKey = "";
        if (StrUtil.isNotBlank((CharSequence)procDefId)) {
            if (StrUtil.isNotBlank((CharSequence)taskDefKey)) {
                try {
                    formKey = this.formService.getTaskFormKey(procDefId, taskDefKey);
                }
                catch (Exception e) {
                    formKey = "";
                }
            }
            if (StrUtil.isBlank((CharSequence)formKey)) {
                formKey = this.formService.getStartFormKey(procDefId);
            }
            if (StrUtil.isBlank((CharSequence)formKey)) {
                formKey = "/404";
            }
        }
        log.debug("getFormKey: {}", (Object)formKey);
        return formKey;
    }

    public ProcessInstance getProcIns(String procInsId) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInsId).singleResult();
    }

    public HistoricProcessInstance getFinishedProcIns(String procInsId) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInsId).singleResult();
    }

    public Page<ProcessVo> getMyStartedProcIns(UserDTO user, Page<ProcessVo> page, Flow flow) throws Exception {
        List histList;
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().startedBy(user.getId()).includeProcessVariables().orderByProcessInstanceStartTime().desc();
        if (flow.getBeginDate() != null) {
            query.startedAfter(flow.getBeginDate());
        }
        if (flow.getEndDate() != null) {
            query.startedBefore(flow.getEndDate());
        }
        if (StrUtil.isNotBlank((CharSequence)flow.getTitle())) {
            query.variableValueLike("title", "%" + flow.getTitle() + "%");
        }
        page.setTotal(query.count());
        if (page.getSize() == -1L) {
            histList = query.list();
        } else {
            int start = (int)((page.getCurrent() - 1L) * page.getSize());
            int size = (int)page.getSize();
            histList = query.involvedUser(user.getId()).listPage(start, size);
        }
        ArrayList records = Lists.newArrayList();
        for (HistoricProcessInstance historicProcessInstance : histList) {
            ProcessVo processVo = this.flowProcessService.queryProcessState(historicProcessInstance.getProcessDefinitionId(), historicProcessInstance.getId());
            processVo.setEndTime(historicProcessInstance.getEndTime());
            processVo.setStartTime(historicProcessInstance.getStartTime());
            processVo.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());
            processVo.setProcessInstanceId(historicProcessInstance.getId());
            processVo.setVars(historicProcessInstance.getProcessVariables());
            processVo.setProcessDefinitionName(historicProcessInstance.getProcessDefinitionName());
            processVo.setVersion(historicProcessInstance.getProcessDefinitionVersion().intValue());
            records.add(processVo);
        }
        page.setRecords((List)records);
        return page;
    }

    public String startProcess(String procDefKey, String businessTable, String businessId, String title) {
        HashMap vars = Maps.newHashMap();
        return this.startProcess(procDefKey, businessTable, businessId, title, (Map)vars);
    }

    public String startProcess(String procDefKey, String businessTable, String businessId, String title, Map<String, Object> vars) {
        String userId;
        if (vars == null) {
            vars = Maps.newHashMap();
        }
        if ((userId = (String)vars.get("applyUserId")) == null) {
            userId = this.userApi.getByToken(TokenProvider.getCurrentToken()).getId();
        }
        String userName = this.userApi.getById(userId).getName();
        vars.put("userName", userName);
        this.identityService.setAuthenticatedUserId(userId);
        if (StrUtil.isNotBlank((CharSequence)title)) {
            vars.put("title", title);
        }
        ProcessInstance procIns = this.runtimeService.startProcessInstanceByKeyAndTenantId(procDefKey, businessTable + ":" + businessId, (Map)vars, this.tenantApi.getCurrentTenantId());
        Flow act = new Flow();
        act.setBusinessTable(businessTable);
        act.setBusinessId(businessId);
        act.setProcInsId(procIns.getId());
        act.setVars((Map)vars);
        this.flowMapper.updateProcInsIdByBusinessId(act);
        return act.getProcInsId();
    }

    public void deleteTask(String taskId, String deleteReason) {
        this.taskService.deleteTask(taskId, deleteReason);
    }

    public void claim(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
    }

    public void complete(Flow flow, Map<String, Object> vars) {
        Task task;
        if (StrUtil.isNotBlank((CharSequence)flow.getProcInsId())) {
            this.taskService.addComment(flow.getTaskId(), flow.getProcInsId(), flow.getComment().getCommentType(), flow.getComment().getFullMessage());
        }
        if (vars == null) {
            vars = Maps.newHashMap();
        }
        if (StrUtil.isNotBlank((CharSequence)flow.getTitle())) {
            vars.put("title", flow.getTitle());
        }
        if (StrUtil.isNotBlank((CharSequence)(task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(flow.getTaskId())).singleResult()).getOwner())) {
            DelegationState delegationState = task.getDelegationState();
            switch (2.$SwitchMap$org$flowable$task$api$DelegationState[delegationState.ordinal()]) {
                case 1: {
                    this.taskService.resolveTask(flow.getTaskId());
                    this.taskService.complete(flow.getTaskId(), (Map)vars);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    this.taskService.complete(flow.getTaskId(), (Map)vars);
                    break;
                }
            }
        } else if (StrUtil.isBlank((CharSequence)task.getAssignee())) {
            this.taskService.claim(flow.getTaskId(), this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
            this.taskService.complete(flow.getTaskId(), (Map)vars);
        } else {
            this.taskService.complete(flow.getTaskId(), (Map)vars);
        }
    }

    public Flow queryTaskState(HistoricActivityInstance histIns) {
        UserDTO user;
        Flow e = new Flow();
        e.setHistIns(histIns);
        if ("startEvent".equals(histIns.getActivityType())) {
            UserDTO user2;
            List il = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(histIns.getProcessInstanceId()).orderByProcessInstanceStartTime().asc()).list();
            if (il.size() > 0 && StrUtil.isNotBlank((CharSequence)((HistoricProcessInstance)il.get(0)).getStartUserId()) && (user2 = this.userApi.getById(((HistoricProcessInstance)il.get(0)).getStartUserId())) != null) {
                e.setAssignee(histIns.getAssignee());
                e.setAssigneeName(user2.getName());
            }
            TaskComment taskComment = new TaskComment();
            taskComment.setStatus("\u5f00\u59cb");
            taskComment.setMessage("\u53d1\u8d77\u6d41\u7a0b");
            e.setComment(taskComment);
            return e;
        }
        if ("endEvent".equals(histIns.getActivityType())) {
            TaskComment taskComment = new TaskComment();
            taskComment.setStatus("\u7ed3\u675f");
            taskComment.setMessage("\u7ed3\u675f\u6d41\u7a0b");
            e.setAssigneeName("\u7cfb\u7edf\u6267\u884c");
            e.setComment(taskComment);
            return e;
        }
        if (StrUtil.isNotEmpty((CharSequence)histIns.getAssignee()) && (user = this.userApi.getById(histIns.getAssignee())) != null) {
            e.setAssignee(histIns.getAssignee());
            e.setAssigneeName(user.getName());
        }
        if (StrUtil.isNotBlank((CharSequence)histIns.getTaskId())) {
            List commentList = this.getTaskComments(histIns.getTaskId());
            HistoricVariableInstanceQuery action = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(histIns.getProcessInstanceId()).taskId(histIns.getTaskId()).variableName("_flow_button_name");
            if (commentList.size() > 0) {
                TaskComment comment = (TaskComment)commentList.get(commentList.size() - 1);
                e.setComment(comment);
            } else {
                e.setComment(new TaskComment());
            }
        }
        if (histIns.getEndTime() == null) {
            ArrayList assignList = Lists.newArrayList();
            this.taskService.getIdentityLinksForTask(histIns.getTaskId()).forEach(identityLink -> assignList.add(this.userApi.getById(identityLink.getUserId())));
            String assignName = Collections3.extractToString((Collection)assignList, (String)"name", (String)",");
            TaskComment taskComment = new TaskComment();
            taskComment.setStatus(ActionType.WAITING.getStatus());
            e.setComment(taskComment);
            e.setAssigneeName(assignName);
        }
        return e;
    }

    public List<TaskComment> getTaskComments(String taskId) {
        return this.jdbcTemplate.query("select * from ACT_HI_COMMENT where TYPE_ like 'COMMENT_%' and TASK_ID_ = '" + taskId + "' order by TIME_ desc", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map getDiagram(String processId) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            String processDefId = "";
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processId).singleResult();
            processDefId = pi == null ? ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processId).singleResult()).getProcessDefinitionId() : pi.getProcessDefinitionId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefId);
            List historyProcess = this.getHistoryProcess(processId);
            LinkedHashSet<String> activityIds = new LinkedHashSet<String>();
            ArrayList<String> flows = new ArrayList<String>();
            for (Object hi : historyProcess) {
                String activityType = hi.getActivityType();
                if (activityType.equals("sequenceFlow") || activityType.equals("exclusiveGateway")) {
                    flows.add(hi.getActivityId());
                    continue;
                }
                if (!(StrUtil.isNotBlank((CharSequence)hi.getAssignee()) && ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(hi.getTaskId())).count() != 0L || "userTask".equals(hi.getActivityType()) && hi.getEndTime() == null || "startEvent".equals(hi.getActivityType())) && !"endEvent".equals(hi.getActivityType())) continue;
                activityIds.add(hi.getActivityId());
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processId)).list();
            for (Task task : tasks) {
                activityIds.remove(task.getTaskDefinitionKey());
                activityIds.add(task.getTaskDefinitionKey());
            }
            byte[] bpmnBytes = this.flowModelService.getBpmnXML(bpmnModel);
            m.put("bpmnXml", new String(bpmnBytes));
            m.put("flows", flows);
            m.put("activityIds", activityIds);
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<HistoricActivityInstance> getHistoryProcess(String processId) {
        List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processId).finished().orderByHistoricActivityInstanceEndTime().asc()).list();
        return list;
    }

    public void auditSave(Flow flow, Map vars) {
        this.complete(flow, vars);
    }

    public boolean isBack(HistoricTaskInstance hisTask) {
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(hisTask.getProcessInstanceId()).singleResult();
        if (pi != null) {
            if (pi.isSuspended()) {
                return false;
            }
            Task currentTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(hisTask.getProcessInstanceId())).list().get(0);
            HistoricTaskInstance lastHisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(hisTask.getProcessInstanceId())).finished().includeProcessVariables()).orderByHistoricTaskInstanceEndTime().desc()).list().get(0);
            if (currentTask.getClaimTime() != null) {
                return false;
            }
            return hisTask.getId().equals(lastHisTask.getId());
        }
        return false;
    }

    public String backTask(String backTaskDefKey, String taskId, TaskComment comment) {
        ActivityInstance targetRealActivityInstance;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (StrUtil.isBlank((CharSequence)task.getAssignee())) {
            this.taskService.claim(taskId, this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
        }
        if ((targetRealActivityInstance = (ActivityInstance)this.runtimeService.createActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityId(backTaskDefKey).list().get(0)).getActivityType().equals("startEvent")) {
            this.flowProcessService.stopProcessInstanceById(task.getProcessInstanceId(), ProcessStatus.REJECT, comment.getMessage());
        } else {
            this.taskService.addComment(taskId, task.getProcessInstanceId(), comment.getCommentType(), comment.getFullMessage());
            this.managementService.executeCommand((Command)new BackUserTaskCmd(this.runtimeService, taskId, backTaskDefKey));
        }
        return task.getProcessInstanceId();
    }

    public List<Flow> getBackNodes(String taskId) {
        Task taskEntity = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processInstanceId = taskEntity.getProcessInstanceId();
        String currActId = taskEntity.getTaskDefinitionKey();
        String processDefinitionId = taskEntity.getProcessDefinitionId();
        Process process = this.repositoryService.getBpmnModel(processDefinitionId).getMainProcess();
        FlowNode currentFlowElement = (FlowNode)process.getFlowElement(currActId, true);
        List activitys = ((ActivityInstanceQuery)this.runtimeService.createActivityInstanceQuery().processInstanceId(processInstanceId).finished().orderByActivityInstanceStartTime().asc()).list();
        List activityIds = activitys.stream().filter(activity -> activity.getActivityType().equals("userTask") || activity.getActivityType().equals("startEvent")).filter(activity -> !activity.getActivityId().equals(currActId)).map(ActivityInstance::getActivityId).distinct().collect(Collectors.toList());
        ArrayList<Flow> result = new ArrayList<Flow>();
        for (String activityId : activityIds) {
            FlowNode toBackFlowElement = (FlowNode)process.getFlowElement(activityId, true);
            if (!FlowableUtils.isReachable((Process)process, (FlowNode)toBackFlowElement, (FlowNode)currentFlowElement)) continue;
            Flow vo = new Flow();
            vo.setTaskDefKey(activityId);
            vo.setTaskName(toBackFlowElement.getName());
            vo.setTaskId(activityId);
            result.add(vo);
        }
        return result;
    }

    public void addSignTask(String taskId, List<String> userIds, String comment, Boolean flag) throws Exception {
        TaskEntityImpl taskEntity = (TaskEntityImpl)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (taskEntity != null) {
            String parentTaskId = taskEntity.getParentTaskId();
            if (StringUtils.isBlank((String)parentTaskId)) {
                taskEntity.setOwner(this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
                taskEntity.setAssignee(null);
                taskEntity.setCountEnabled(true);
                if (flag.booleanValue()) {
                    taskEntity.setScopeType("after");
                } else {
                    taskEntity.setScopeType("before");
                }
                this.taskService.saveTask((Task)taskEntity);
            }
        } else {
            throw new Exception("\u4e0d\u5b58\u5728\u4efb\u52a1\u5b9e\u4f8b\uff0c\u8bf7\u786e\u8ba4!");
        }
        this.createSignSubTasks(userIds, (TaskEntity)taskEntity);
        String type = flag != false ? ActionType.ADD_AFTER_MULTI_INSTANCE.toString() : ActionType.ADD_BEFORE_MULTI_INSTANCE.toString();
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), type, comment);
    }

    private void createSignSubTasks(List<String> userIds, TaskEntity taskEntity) {
        if (CollectionUtils.isNotEmpty(userIds)) {
            long candidateCount;
            Task taskInfo;
            String parentTaskId = taskEntity.getParentTaskId();
            if (StringUtils.isBlank((String)parentTaskId)) {
                parentTaskId = taskEntity.getId();
            }
            String finalParentTaskId = parentTaskId;
            userIds.forEach(userCode -> {
                if (StrUtil.isNotBlank((CharSequence)userCode)) {
                    this.createSubTask(taskEntity, finalParentTaskId, userCode);
                }
            });
            String taskId = taskEntity.getId();
            if (StringUtils.isBlank((String)taskEntity.getParentTaskId())) {
                TaskEntity task = this.createSubTask(taskEntity, finalParentTaskId, this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
                taskId = task.getId();
            }
            if (null != (taskInfo = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult())) {
                this.taskService.complete(taskId);
            }
            if ((candidateCount = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(parentTaskId)).taskCandidateUser(this.userApi.getByToken(TokenProvider.getCurrentToken()).getId())).count()) > 0L) {
                this.taskService.deleteCandidateUser(parentTaskId, this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
            }
        }
    }

    protected TaskEntity createSubTask(TaskEntity ptask, String ptaskId, String assignee) {
        TaskEntity task = null;
        if (ptask != null) {
            task = (TaskEntity)this.taskService.newTask(UUID.randomUUID().toString());
            task.setCategory(ptask.getCategory());
            task.setDescription(ptask.getDescription());
            task.setTenantId(ptask.getTenantId());
            task.setAssignee(assignee);
            task.setName(ptask.getName());
            task.setParentTaskId(ptaskId);
            task.setProcessDefinitionId(ptask.getProcessDefinitionId());
            task.setProcessInstanceId(ptask.getProcessInstanceId());
            task.setTaskDefinitionKey(ptask.getTaskDefinitionKey());
            task.setTaskDefinitionId(ptask.getTaskDefinitionId());
            task.setPriority(ptask.getPriority());
            task.setCreateTime(new Date());
            this.taskService.saveTask((Task)task);
        }
        return task;
    }
}

