/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.flowable.model.TaskComment;
import com.jeeplus.flowable.service.FlowableBpmnModelService;
import com.jeeplus.flowable.service.converter.json.FlowModelService;
import com.jeeplus.flowable.vo.ActionType;
import com.jeeplus.flowable.vo.ProcessStatus;
import com.jeeplus.flowable.vo.ProcessVo;
import com.jeeplus.flowable.vo.TaskVo;
import com.jeeplus.sys.feign.ITenantApi;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.UserDTO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class FlowProcessService {
    private static final Logger log = LoggerFactory.getLogger(FlowProcessService.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private FlowModelService flowModelService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FlowableBpmnModelService flowableBpmnModelService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ITenantApi tenantApi;

    public ProcessDefinition getProcessDefinitionByKey(String key) {
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        processDefinitionQuery.processDefinitionKey(key);
        List processDefinitionList = processDefinitionQuery.list();
        if (processDefinitionList.size() > 0) {
            return (ProcessDefinition)processDefinitionList.get(0);
        }
        return null;
    }

    public boolean isAuth(UserDTO user, String processDefId) {
        List identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefId);
        if (identityLinks.size() == 0) {
            return true;
        }
        for (IdentityLink identityLink : identityLinks) {
            if (user.getId().equals(identityLink.getUserId())) {
                return true;
            }
            if (!("," + user.getRoleIds() + ",").contains("," + identityLink.getGroupId() + ",")) continue;
            return true;
        }
        return false;
    }

    public Page<Map> processList(Page<Map> page, String category) {
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionTenantId(this.tenantApi.getCurrentTenantId()).active().latestVersion().orderByProcessDefinitionKey().asc();
        if (StrUtil.isNotEmpty((CharSequence)category)) {
            processDefinitionQuery.processDefinitionCategory(category);
        }
        List processDefinitionList = processDefinitionQuery.list();
        ArrayList records = Lists.newArrayList();
        for (ProcessDefinition processDefinition : processDefinitionList) {
            if (!this.isAuth(this.userApi.getByToken(TokenProvider.getCurrentToken()), processDefinition.getId())) continue;
            String deploymentId = processDefinition.getDeploymentId();
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            pMap.put("id", processDefinition.getId());
            pMap.put("category", processDefinition.getCategory());
            pMap.put("key", processDefinition.getKey());
            pMap.put("name", processDefinition.getName());
            pMap.put("version", "V:" + processDefinition.getVersion());
            pMap.put("resourceName", processDefinition.getResourceName());
            pMap.put("diagramResourceName", processDefinition.getDiagramResourceName());
            pMap.put("deploymentId", processDefinition.getDeploymentId());
            pMap.put("suspended", processDefinition.isSuspended());
            pMap.put("deploymentTime", deployment.getDeploymentTime());
            records.add(pMap);
        }
        page.setRecords((List)records);
        page.setTotal((long)page.getRecords().size());
        return page;
    }

    public Page<ProcessVo> runningList(Page<ProcessInstance> page, String title, String procInsId, String procDefKey) throws Exception {
        List runningList;
        ArrayList<ProcessVo> result = new ArrayList<ProcessVo>();
        Page resultPage = new Page();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(this.tenantApi.getCurrentTenantId()).includeProcessVariables();
        if (StrUtil.isNotBlank((CharSequence)procInsId)) {
            processInstanceQuery.processInstanceId(procInsId);
        }
        if (StrUtil.isNotBlank((CharSequence)procDefKey)) {
            processInstanceQuery.processDefinitionKey(procDefKey);
        }
        if (StrUtil.isNotBlank((CharSequence)title)) {
            processInstanceQuery.variableValueLike("title", "%" + title + "%");
        }
        page.setTotal(processInstanceQuery.count());
        resultPage.setTotal(processInstanceQuery.count());
        if (page.getSize() == -1L) {
            runningList = processInstanceQuery.list();
        } else {
            int start = (int)((page.getCurrent() - 1L) * page.getSize());
            int size = (int)page.getSize();
            runningList = processInstanceQuery.listPage(start, size);
        }
        for (ProcessInstance p : runningList) {
            ProcessVo processVo = this.queryProcessState(p.getProcessDefinitionId(), p.getId());
            processVo.setProcessInstanceId(p.getProcessInstanceId());
            processVo.setProcessDefinitionId(p.getProcessDefinitionId());
            processVo.setProcessDefinitionName(p.getProcessDefinitionName());
            processVo.setActivityId(p.getActivityId());
            processVo.setVars(p.getProcessVariables());
            result.add(processVo);
        }
        resultPage.setRecords(result);
        return resultPage;
    }

    public Page<ProcessVo> historyList(Page<ProcessVo> page, String title, String procInsId, String procDefKey) throws Exception {
        List list;
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().processInstanceTenantId(this.tenantApi.getCurrentTenantId()).includeProcessVariables().finished().orderByProcessInstanceEndTime().desc();
        if (StrUtil.isNotBlank((CharSequence)procInsId)) {
            query.processInstanceId(procInsId);
        }
        if (StrUtil.isNotBlank((CharSequence)title)) {
            query.variableValueLike("title", "%" + title + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)procDefKey)) {
            query.processDefinitionKey(procDefKey);
        }
        page.setTotal(query.count());
        if (page.getSize() == -1L) {
            list = query.list();
        } else {
            int start = (int)((page.getCurrent() - 1L) * page.getSize());
            int size = (int)page.getSize();
            list = query.listPage(start, size);
        }
        ArrayList mapList = Lists.newArrayList();
        for (HistoricProcessInstance instance : list) {
            ProcessVo processVo = this.queryProcessState(instance.getProcessDefinitionId(), instance.getId());
            processVo.setVars(instance.getProcessVariables());
            processVo.setProcessDefinitionName(instance.getProcessDefinitionName());
            processVo.setStartTime(instance.getStartTime());
            processVo.setEndTime(instance.getEndTime());
            processVo.setProcessInstanceId(instance.getId());
            processVo.setProcessDefinitionId(instance.getProcessDefinitionId());
            processVo.setDeleteReason(instance.getDeleteReason());
            mapList.add(processVo);
        }
        page.setRecords((List)mapList);
        return page;
    }

    public InputStream resourceRead(String procDefId, String proInsId, String resType) throws Exception {
        if (StrUtil.isBlank((CharSequence)procDefId)) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(proInsId).singleResult();
            procDefId = processInstance.getProcessDefinitionId();
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(procDefId).singleResult();
        String resourceName = "";
        if (resType.equals("image")) {
            resourceName = processDefinition.getDiagramResourceName();
        } else if (resType.equals("xml")) {
            resourceName = processDefinition.getResourceName();
        }
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), resourceName);
        return resourceAsStream;
    }

    public ResponseEntity deploy(String exportDir, String category, MultipartFile file) {
        String message = "";
        String fileName = file.getOriginalFilename();
        try {
            InputStream fileInputStream = file.getInputStream();
            Deployment deployment = null;
            String extension = FilenameUtils.getExtension((String)fileName);
            if (extension.equals("zip") || extension.equals("bar")) {
                ZipInputStream zip = new ZipInputStream(fileInputStream);
                deployment = this.repositoryService.createDeployment().addZipInputStream(zip).deploy();
            } else if (extension.equals("png")) {
                deployment = this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
            } else if (fileName.indexOf("bpmn20.xml") != -1) {
                deployment = this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
            } else if (extension.equals("bpmn")) {
                String baseName = FilenameUtils.getBaseName((String)fileName);
                deployment = this.repositoryService.createDeployment().addInputStream(baseName + ".bpmn20.xml", fileInputStream).deploy();
            } else {
                return ResponseEntity.badRequest().body((Object)("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff1a" + extension));
            }
            List list = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
            for (ProcessDefinition processDefinition : list) {
                this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), category);
                message = message + "\u90e8\u7f72\u6210\u529f\uff0c\u6d41\u7a0bID=" + processDefinition.getId() + "<br/>";
            }
            if (list.size() == 0) {
                return ResponseEntity.badRequest().body((Object)"\u90e8\u7f72\u5931\u8d25\uff0c\u6ca1\u6709\u6d41\u7a0b\u3002");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body((Object)("\u90e8\u7f72\u5931\u8d25:" + e.getMessage()));
        }
        return ResponseEntity.ok((Object)message);
    }

    public void updateCategory(String procDefId, String category) {
        this.repositoryService.setProcessDefinitionCategory(procDefId, category);
    }

    public String updateState(String state, String procDefId) {
        if (state.equals("active")) {
            this.repositoryService.activateProcessDefinitionById(procDefId, true, null);
            return "\u5df2\u6fc0\u6d3bID\u4e3a[" + procDefId + "]\u7684\u6d41\u7a0b\u5b9a\u4e49\u3002";
        }
        if (state.equals("suspend")) {
            this.repositoryService.suspendProcessDefinitionById(procDefId, true, null);
            return "\u5df2\u6302\u8d77ID\u4e3a[" + procDefId + "]\u7684\u6d41\u7a0b\u5b9a\u4e49\u3002";
        }
        return "\u65e0\u64cd\u4f5c";
    }

    public Model convertToModel(String procDefId) throws UnsupportedEncodingException, XMLStreamException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(procDefId).singleResult();
        InputStream bpmnStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        InputStreamReader in = new InputStreamReader(bpmnStream, "UTF-8");
        XMLStreamReader xtr = xif.createXMLStreamReader(in);
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        BpmnJsonConverter converter = new BpmnJsonConverter();
        ObjectNode modelNode = converter.convertToJson(bpmnModel);
        Model modelData = this.repositoryService.newModel();
        modelData.setKey(processDefinition.getKey());
        modelData.setName(processDefinition.getResourceName());
        modelData.setCategory(processDefinition.getCategory());
        modelData.setDeploymentId(processDefinition.getDeploymentId());
        modelData.setVersion(Integer.valueOf(Integer.parseInt(String.valueOf(this.repositoryService.createModelQuery().modelKey(modelData.getKey()).count() + 1L))));
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", processDefinition.getName());
        modelObjectNode.put("revision", modelData.getVersion());
        modelObjectNode.put("description", processDefinition.getDescription());
        modelData.setMetaInfo(modelObjectNode.toString());
        this.modelService.saveModel(procDefId, modelData.getName(), modelData.getKey(), processDefinition.getDescription(), modelObjectNode.toString(), true, modelData.getVersion().toString(), SecurityUtils.getCurrentUserId());
        return modelData;
    }

    public List<String> exportDiagrams(String exportDir) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        List list = this.repositoryService.createProcessDefinitionQuery().list();
        for (ProcessDefinition processDefinition : list) {
            File file;
            String diagramResourceName = processDefinition.getDiagramResourceName();
            String key = processDefinition.getKey();
            int version = processDefinition.getVersion();
            String diagramPath = "";
            InputStream resourceAsStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), diagramResourceName);
            byte[] b = new byte[resourceAsStream.available()];
            int len = -1;
            resourceAsStream.read(b, 0, b.length);
            String diagramDir = exportDir + "/" + key + "/" + version;
            File diagramDirFile = new File(diagramDir);
            if (!diagramDirFile.exists()) {
                diagramDirFile.mkdirs();
            }
            if ((file = new File(diagramPath = diagramDir + "/" + diagramResourceName)).exists()) {
                log.debug("diagram exist, ignore... : {}", (Object)diagramPath);
                files.add(diagramPath);
                continue;
            }
            file.createNewFile();
            log.debug("export diagram to : {}", (Object)diagramPath);
            FileUtils.writeByteArrayToFile((File)file, (byte[])b, (boolean)true);
            files.add(diagramPath);
        }
        return files;
    }

    public void deleteDeployment(String deploymentId) {
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void deleteProcIns(String procInsId, String deleteReason) {
        this.stopProcessInstanceById(procInsId, ProcessStatus.DELETED, deleteReason);
    }

    public void stopProcessInstanceById(String procInsId, ProcessStatus processStatus, String comment) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInsId).singleResult();
        if (processInstance != null) {
            Task currentTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInsId)).list().get(0);
            TaskComment taskComment = new TaskComment();
            if (processStatus == ProcessStatus.REVOKE) {
                taskComment.setType(ActionType.REVOKE.getType());
                taskComment.setStatus(ActionType.REVOKE.getStatus());
                taskComment.setMessage(comment);
            } else if (processStatus == ProcessStatus.STOP) {
                taskComment.setType(ActionType.STOP.getType());
                taskComment.setStatus(ActionType.STOP.getStatus());
                taskComment.setMessage(comment);
            } else if (processStatus == ProcessStatus.REJECT) {
                taskComment.setType(ActionType.REJECT.getType());
                taskComment.setStatus(ActionType.REJECT.getStatus());
                taskComment.setMessage(comment);
            } else if (processStatus == ProcessStatus.DELETED) {
                taskComment.setType(ActionType.DELETED.getType());
                taskComment.setStatus(ActionType.DELETED.getStatus());
                taskComment.setMessage(comment);
            }
            this.taskService.addComment(currentTask.getId(), procInsId, taskComment.getCommentType(), taskComment.getFullMessage());
            if (StrUtil.isBlank((CharSequence)currentTask.getAssignee())) {
                this.taskService.claim(currentTask.getId(), this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
            }
            this.runtimeService.setVariable(procInsId, "_process_status_code", (Object)processStatus.getCode());
            List endNodes = this.flowableBpmnModelService.findEndFlowElement(processInstance.getProcessDefinitionId());
            String endId = ((EndEvent)endNodes.get(0)).getId();
            List executions = this.runtimeService.createExecutionQuery().parentId(procInsId).list();
            ArrayList executionIds = new ArrayList();
            executions.forEach(execution -> executionIds.add(execution.getId()));
            this.moveExecutionsToSingleActivityId(executionIds, endId);
        }
    }

    public void callBackProcessInstanceById(String procInsId) {
        this.stopProcessInstanceById(procInsId, ProcessStatus.REVOKE, ProcessStatus.REVOKE.getStatus());
    }

    protected void moveExecutionsToSingleActivityId(List<String> executionIds, String activityId) {
        this.runtimeService.createChangeActivityStateBuilder().moveExecutionsToSingleActivityId(executionIds, activityId).changeState();
    }

    public void delHistoryProcInsById(String procInsId) {
        this.historyService.deleteHistoricProcessInstance(procInsId);
    }

    public ProcessDefinition getProcessDefinition(String proDefId) {
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        if (StrUtil.isNotBlank((CharSequence)proDefId)) {
            processDefinitionQuery.processDefinitionId(proDefId);
        }
        ProcessDefinition p = (ProcessDefinition)processDefinitionQuery.singleResult();
        return p;
    }

    public Map getImageStream(String processDefId) {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefId);
            byte[] bpmnBytes = this.flowModelService.getBpmnXML(bpmnModel);
            m.put("bpmnXml", new String(bpmnBytes));
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProcessVo queryProcessState(String processDefinitionId, String processInstanceId) throws Exception {
        ProcessVo processVo = new ProcessVo();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (pi != null) {
            if (pi.isSuspended()) {
                processVo.setProcessStatus(ProcessStatus.SUSPENDED);
                return processVo;
            }
            processVo.setProcessStatus(ProcessStatus.WAITING);
            if (((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list().size() != 0) {
                Task currentTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list().get(0);
                processVo.setTask(new TaskVo((TaskInfo)currentTask));
                processVo.setTaskName(currentTask.getName());
            }
            return processVo;
        }
        HistoricProcessInstance pi2 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        List historicActivityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finished().orderByHistoricActivityInstanceEndTime().desc()).list().stream().filter(activity -> activity.getActivityType().equals("userTask") || activity.getActivityType().equals("endEvent") || activity.getActivityType().equals("startEvent")).distinct().collect(Collectors.toList());
        Process process = this.repositoryService.getBpmnModel(processDefinitionId).getMainProcess();
        String taskName = "";
        if (historicActivityInstanceList.size() != 0) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstanceList.get(0);
            FlowNode flowElement = (FlowNode)process.getFlowElement(historicActivityInstance.getActivityId(), true);
            taskName = flowElement.getName();
        }
        if (pi2 != null) {
            HistoricVariableInstance processStatusInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName("_process_status_code").singleResult();
            if (pi2.getDeleteReason() == null && processStatusInstance == null) {
                processVo.setProcessStatus(ProcessStatus.AGREE);
                processVo.setTaskName(taskName);
                return processVo;
            }
            if (pi2.getDeleteReason() != null) {
                processVo.setProcessStatus(ProcessStatus.STOP);
                processVo.setTaskName(taskName);
                processVo.setDeleteReason(pi2.getDeleteReason());
                return processVo;
            }
            int code = Integer.valueOf(processStatusInstance.getValue().toString());
            ProcessStatus processStatus = ProcessStatus.value((int)code);
            processVo.setProcessStatus(processStatus);
            processVo.setTaskName(taskName);
            return processVo;
        }
        processVo.setProcessStatus(ProcessStatus.DELETED);
        processVo.setTaskName(taskName);
        return processVo;
    }
}

