/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.controller;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.flowable.model.Flow;
import com.jeeplus.flowable.service.FlowTaskService;
import com.jeeplus.sys.feign.IUserApi;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONObject;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.form.FormProperty;
import org.flowable.engine.form.StartFormData;
import org.flowable.engine.form.TaskFormData;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowable/form"})
public class FlowableFormController {
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FormService formService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IUserApi userApi;

    @PostMapping(value={"submitStartFormData"})
    public ResponseEntity submitStartFormData(String assignee, String processDefinitionId, String title, @RequestParam(value="data") String data) {
        Task task;
        StartFormData formData = this.formService.getStartFormData(processDefinitionId);
        List formProperties = formData.getFormProperties();
        JSONObject jData = JSONObject.fromObject((Object)data);
        HashMap<String, String> formValues = new HashMap<String, String>();
        String userId = this.userApi.getByToken(TokenProvider.getCurrentToken()).getId();
        String userName = this.userApi.getById(userId).getName();
        formValues.put("userName", userName);
        this.identityService.setAuthenticatedUserId(userId);
        if (StrUtil.isNotBlank((CharSequence)title)) {
            formValues.put("title", title);
        }
        for (FormProperty formProperty : formProperties) {
            if (!formProperty.isWritable() || !jData.has(formProperty.getId())) continue;
            String value = jData.getString(formProperty.getId());
            formValues.put(formProperty.getId(), value);
        }
        String procInsId = this.formService.submitStartFormData(processDefinitionId, formValues).getId();
        if (StrUtil.isNotBlank((CharSequence)assignee) && (task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInsId)).active().singleResult()) != null) {
            this.taskService.setAssignee(task.getId(), assignee);
        }
        return ResponseEntity.ok((Object)procInsId);
    }

    @GetMapping(value={"getTaskFormData"})
    public ResponseEntity getTaskFormData(String taskId) {
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        return ResponseEntity.ok((Object)taskFormData.getFormProperties());
    }

    @GetMapping(value={"getStartFormData"})
    public ResponseEntity getStartFormData(String processDefinitionId) {
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        return ResponseEntity.ok((Object)startFormData.getFormProperties());
    }

    @GetMapping(value={"getHistoryTaskFormData"})
    public ResponseEntity getHistroyTaskFormData(String processInstanceId, String procDefId, String taskDefKey) {
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
        HashMap<String, Object> historicVariableMap = new HashMap<String, Object>();
        for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
            historicVariableMap.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
        }
        ArrayList list = Lists.newArrayList();
        FlowElement node = this.repositoryService.getBpmnModel(procDefId).getFlowElement(taskDefKey);
        if (node != null) {
            List formPropertyList = Lists.newArrayList();
            if (node instanceof UserTask) {
                formPropertyList = ((UserTask)node).getFormProperties();
            } else if (node instanceof StartEvent) {
                formPropertyList = ((StartEvent)node).getFormProperties();
            }
            for (org.flowable.bpmn.model.FormProperty formProperty : formPropertyList) {
                try {
                    HashMap<String, Object> formPropertyMap = new HashMap<String, Object>();
                    Field field = formProperty.getClass().getDeclaredField("readable");
                    field.setAccessible(true);
                    boolean readable = (Boolean)field.get(formProperty);
                    if (!readable) continue;
                    formPropertyMap.put("id", formProperty.getId());
                    formPropertyMap.put("name", formProperty.getName());
                    formPropertyMap.put("value", historicVariableMap.get(formProperty.getId()));
                    formPropertyMap.put("readable", readable);
                    list.add(formPropertyMap);
                }
                catch (Exception formPropertyMap) {}
            }
        } else {
            List formPropertyList = this.formService.getStartFormData(procDefId).getFormProperties();
            for (FormProperty formProperty : formPropertyList) {
                try {
                    HashMap<String, Object> formPropertyMap = new HashMap<String, Object>();
                    boolean readable = formProperty.isReadable();
                    if (!readable) continue;
                    formPropertyMap.put("id", formProperty.getId());
                    formPropertyMap.put("name", formProperty.getName());
                    formPropertyMap.put("value", historicVariableMap.get(formProperty.getId()));
                    formPropertyMap.put("readable", readable);
                    list.add(formPropertyMap);
                }
                catch (Exception exception) {}
            }
        }
        return ResponseEntity.ok((Object)list);
    }

    @PostMapping(value={"submitTaskFormData"})
    public ResponseEntity submitTaskFormData(Flow flow, @RequestParam(value="data") String data) {
        Task task;
        TaskFormData taskFormData = this.formService.getTaskFormData(flow.getTaskId());
        List formProperties = taskFormData.getFormProperties();
        JSONObject jData = JSONObject.fromObject((Object)data);
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        HashSet<String> noCommitValues = new HashSet<String>();
        for (FormProperty formProperty : formProperties) {
            if (formProperty.isWritable()) continue;
            noCommitValues.add(formProperty.getId());
        }
        for (Object str : jData.keySet()) {
            if (noCommitValues.contains(str.toString())) continue;
            Object value = jData.get(str.toString());
            formValues.put(str.toString(), value);
        }
        formValues.put("assignee", "");
        this.flowTaskService.complete(flow, formValues);
        if (StrUtil.isNotBlank((CharSequence)flow.getAssignee()) && (task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(flow.getProcInsId())).active().singleResult()) != null) {
            this.taskService.setAssignee(task.getId(), flow.getAssignee());
        }
        return ResponseEntity.ok((Object)flow.getProcInsId());
    }
}

