/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.jeeplus.extension.service.NodeSettingService;
import com.jeeplus.extension.service.TaskDefExtensionService;
import com.jeeplus.flowable.mapper.FlowModelMapper;
import com.jeeplus.flowable.model.FlowModel;
import com.jeeplus.flowable.service.FlowProcessService;
import com.jeeplus.sys.feign.ITenantApi;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.service.FlowableModelQueryService;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@Transactional
public class FlowableModelService
extends ServiceImpl<FlowModelMapper, FlowModel> {
    private static final Logger log = LoggerFactory.getLogger(FlowableModelService.class);
    @Autowired
    FlowProcessService flowProcessService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ModelService flowModelService;
    @Autowired
    private NodeSettingService nodeSettingService;
    @Autowired
    private TaskDefExtensionService taskDefExtensionService;
    @Autowired
    protected FlowableModelQueryService modelQueryService;
    @Autowired
    private ITenantApi tenantApi;
    protected BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public Page<FlowModel> getModels(Page<FlowModel> page, @RequestParam(required=false) String filter, @RequestParam(required=false) String sort, @RequestParam(required=false) Integer modelType, HttpServletRequest request) {
        ResultListDataRepresentation modelQuery = this.modelQueryService.getModels(filter, sort, modelType, request);
        page.setTotal(modelQuery.getTotal().longValue());
        ArrayList flowModelList = Lists.newArrayList();
        List list = modelQuery.getData();
        for (Object o : list) {
            FlowModel flowModel = new FlowModel();
            ModelRepresentation m = (ModelRepresentation)o;
            flowModel.setName(m.getName());
            flowModel.setId(m.getId());
            flowModel.setComment(m.getComment());
            flowModel.setKey(m.getKey());
            flowModel.setCreatedBy(m.getCreatedBy());
            flowModel.setUpdateDate(m.getLastUpdated());
            flowModel.setLastUpdated(m.getLastUpdated());
            flowModelList.add(flowModel);
            ProcessDefinition processDefinition = this.flowProcessService.getProcessDefinitionByKey(m.getKey());
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            if (processDefinition != null) {
                String deploymentId = processDefinition.getDeploymentId();
                Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
                pMap.put("id", processDefinition.getId());
                pMap.put("category", processDefinition.getCategory());
                pMap.put("key", processDefinition.getKey());
                pMap.put("name", processDefinition.getName());
                pMap.put("version", "V:" + processDefinition.getVersion());
                pMap.put("resourceName", processDefinition.getResourceName());
                pMap.put("diagramResourceName", processDefinition.getDiagramResourceName());
                pMap.put("deploymentId", processDefinition.getDeploymentId());
                pMap.put("suspended", processDefinition.isSuspended());
                pMap.put("deploymentTime", deployment.getDeploymentTime());
            }
            flowModel.setProcDef(pMap);
        }
        page.setRecords((List)flowModelList);
        return page;
    }

    public String changeXmlToJson(String xml) {
        try {
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            InputStreamReader xmlIn = new InputStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), "UTF-8");
            XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
            BpmnModel bpmnModel = this.bpmnXmlConverter.convertToBpmnModel(xtr);
            if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                throw new BadRequestException("No process found in definition ");
            }
            if (bpmnModel.getLocationMap().size() == 0) {
                BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                bpmnLayout.execute();
            }
            ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
            return modelNode.toString();
        }
        catch (BadRequestException var14) {
            throw var14;
        }
        catch (Exception var15) {
            throw new BadRequestException("Import failed for , error message " + var15.getMessage());
        }
    }

    public String deploy(String id, String category, String tenantId) {
        String message = "";
        try {
            Model model = this.flowModelService.getModel(id);
            byte[] bpmnBytes = this.flowModelService.getBpmnXML((AbstractModel)model);
            String processName = model.getName();
            if (!StringUtils.endsWith((CharSequence)processName, (CharSequence)".bpmn20.xml")) {
                processName = processName + ".bpmn20.xml";
            }
            Deployment deployment = null;
            deployment = StrUtil.isNotEmpty((CharSequence)tenantId) ? this.repositoryService.createDeployment().tenantId(tenantId).addBytes(processName, bpmnBytes).name(model.getName()).key(model.getKey()).deploy() : this.repositoryService.createDeployment().tenantId(this.tenantApi.getCurrentTenantId()).addBytes(processName, bpmnBytes).name(model.getName()).key(model.getKey()).deploy();
            log.debug("\u6d41\u7a0b\u90e8\u7f72--------deploy\uff1a" + deployment);
            List list = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
            for (ProcessDefinition processDefinition : list) {
                if (StringUtils.isNotBlank((CharSequence)category)) {
                    this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), category);
                }
                message = message + "\u90e8\u7f72\u6210\u529f\uff0c\u6d41\u7a0bID=" + processDefinition.getId();
            }
            if (list.size() == 0) {
                message = "\u90e8\u7f72\u5931\u8d25\uff0c\u6ca1\u6709\u6d41\u7a0b\u3002";
            }
        }
        catch (Exception e) {
            throw new FlowableException("\u8bbe\u8ba1\u6a21\u578b\u56fe\u4e0d\u6b63\u786e\uff0c\u68c0\u67e5\u6a21\u578b\u6b63\u786e\u6027\uff0c\u6a21\u578bID=" + id, (Throwable)e);
        }
        return message;
    }

    public String export(String id, HttpServletResponse response) {
        try {
            Model modelData = this.flowModelService.getModel(id);
            byte[] bpmnBytes = this.flowModelService.getBpmnXML((AbstractModel)modelData);
            return new String(bpmnBytes);
        }
        catch (Exception e) {
            throw new FlowableException("\u5bfc\u51famodel\u7684xml\u6587\u4ef6\u5931\u8d25\uff0c\u6a21\u578bID=" + id, (Throwable)e);
        }
    }

    public void updateCategory(String id, String category) {
        org.flowable.engine.repository.Model modelData = this.repositoryService.getModel(id);
        modelData.setCategory(category);
        this.repositoryService.saveModel(modelData);
    }

    public void delete(String id) {
        Model model = this.flowModelService.getModel(id);
        try {
            this.deleteDeployment(model.getKey());
            this.flowModelService.deleteModel(model.getId());
            this.taskDefExtensionService.deleteByProcessDefId(model.getKey());
            this.nodeSettingService.deleteByProcessDefId(model.getKey());
        }
        catch (Exception var4) {
            log.error("Error while deleting: ", (Throwable)var4);
            throw new BadRequestException("Model cannot be deleted: " + id);
        }
    }

    public void deleteDeployment(String key) {
        ProcessDefinition processDefinition = this.flowProcessService.getProcessDefinitionByKey(key);
        if (processDefinition == null) {
            return;
        }
        try {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId(), true);
        }
        catch (Exception var4) {
            log.error("Error while deleting: ", (Throwable)var4);
            throw new BadRequestException("Process cannot be deleted: " + processDefinition.getDeploymentId());
        }
        this.deleteDeployment(key);
    }
}

