/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.common.cmd;

import com.google.common.collect.Sets;
import com.jeeplus.flowable.utils.FlowableUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.runtime.Execution;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class BackUserTaskCmd
implements Command<String>,
Serializable {
    public static final long serialVersionUID = 1L;
    protected RuntimeService runtimeService;
    protected String taskId;
    protected String targetActivityId;

    public BackUserTaskCmd(RuntimeService runtimeService, String taskId, String targetActivityId) {
        this.runtimeService = runtimeService;
        this.taskId = taskId;
        this.targetActivityId = targetActivityId;
    }

    public String execute(CommandContext commandContext) {
        if (this.targetActivityId == null || this.targetActivityId.length() == 0) {
            throw new FlowableException("TargetActivityId cannot be empty");
        }
        TaskEntity task = CommandContextUtil.getTaskService().getTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        String sourceActivityId = task.getTaskDefinitionKey();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess((String)processDefinitionId);
        FlowNode sourceFlowElement = (FlowNode)process.getFlowElement(sourceActivityId, true);
        if (!(sourceFlowElement instanceof UserTask)) {
            throw new FlowableException("Task with id:" + this.taskId + " is not a UserTask");
        }
        FlowNode targetFlowElement = (FlowNode)process.getFlowElement(this.targetActivityId, true);
        if (!FlowableUtils.isReachable((Process)process, (FlowNode)targetFlowElement, (FlowNode)sourceFlowElement)) {
            throw new FlowableException("Cannot back to [" + this.targetActivityId + "]");
        }
        String[] sourceAndTargetRealActivityId = FlowableUtils.getSourceAndTargetRealActivityId((FlowNode)sourceFlowElement, (FlowNode)targetFlowElement);
        String sourceRealActivityId = sourceAndTargetRealActivityId[0];
        String targetRealActivityId = sourceAndTargetRealActivityId[1];
        Map specialGatewayNodes = FlowableUtils.getSpecialGatewayElements((FlowElementsContainer)process);
        ArrayList sourceInSpecialGatewayList = new ArrayList();
        ArrayList targetInSpecialGatewayList = new ArrayList();
        this.setSpecialGatewayList(sourceRealActivityId, targetRealActivityId, specialGatewayNodes, sourceInSpecialGatewayList, targetInSpecialGatewayList);
        Set sourceRealAcitivtyIds = null;
        String targetRealSpecialGateway = null;
        if (targetInSpecialGatewayList.isEmpty() && sourceInSpecialGatewayList.isEmpty()) {
            sourceRealAcitivtyIds = Sets.newHashSet((Object[])new String[]{sourceRealActivityId});
        } else if (targetInSpecialGatewayList.isEmpty() && !sourceInSpecialGatewayList.isEmpty()) {
            sourceRealAcitivtyIds = (Set)specialGatewayNodes.get(sourceInSpecialGatewayList.get(0));
        } else if (!targetInSpecialGatewayList.isEmpty() && sourceInSpecialGatewayList.isEmpty()) {
            sourceRealAcitivtyIds = Sets.newHashSet((Object[])new String[]{sourceRealActivityId});
            targetRealSpecialGateway = (String)targetInSpecialGatewayList.get(0);
        } else {
            int diffSpecialGatewayLevel = FlowableUtils.getDiffLevel(sourceInSpecialGatewayList, targetInSpecialGatewayList);
            if (diffSpecialGatewayLevel == -1) {
                sourceRealAcitivtyIds = Sets.newHashSet((Object[])new String[]{sourceRealActivityId});
            } else {
                sourceRealAcitivtyIds = sourceInSpecialGatewayList.size() == diffSpecialGatewayLevel ? Sets.newHashSet((Object[])new String[]{sourceRealActivityId}) : (Set)specialGatewayNodes.get(sourceInSpecialGatewayList.get(diffSpecialGatewayLevel));
                if (targetInSpecialGatewayList.size() != diffSpecialGatewayLevel) {
                    targetRealSpecialGateway = (String)targetInSpecialGatewayList.get(diffSpecialGatewayLevel);
                }
            }
        }
        List realExecutions = this.getRealExecutions(commandContext, processInstanceId, task.getExecutionId(), sourceRealActivityId, sourceRealAcitivtyIds);
        List realExecutionIds = realExecutions.stream().map(Execution::getId).collect(Collectors.toList());
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveExecutionsToSingleActivityId(realExecutionIds, targetRealActivityId).changeState();
        if (targetRealSpecialGateway != null) {
            this.createTargetInSpecialGatewayEndExecutions(commandContext, realExecutions, process, targetInSpecialGatewayList, targetRealSpecialGateway);
        }
        return targetRealActivityId;
    }

    private void setSpecialGatewayList(String sourceActivityId, String targetActivityId, Map<String, Set<String>> specialGatewayNodes, List<String> sourceInSpecialGatewayList, List<String> targetInSpecialGatewayList) {
        for (Map.Entry<String, Set<String>> entry : specialGatewayNodes.entrySet()) {
            if (entry.getValue().contains(sourceActivityId)) {
                sourceInSpecialGatewayList.add(entry.getKey());
            }
            if (!entry.getValue().contains(targetActivityId)) continue;
            targetInSpecialGatewayList.add(entry.getKey());
        }
    }

    private void createTargetInSpecialGatewayEndExecutions(CommandContext commandContext, List<ExecutionEntity> excutionEntitys, Process process, List<String> targetInSpecialGatewayList, String targetRealSpecialGateway) {
        String parentExecutionId = excutionEntitys.iterator().next().getParentId();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext);
        ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionEntityManager.findById(parentExecutionId);
        for (int index = targetInSpecialGatewayList.indexOf(targetRealSpecialGateway); index < targetInSpecialGatewayList.size(); ++index) {
            String targetInSpecialGateway = targetInSpecialGatewayList.get(index);
            String targetInSpecialGatewayEndId = targetInSpecialGateway + "_end";
            FlowNode targetInSpecialGatewayEnd = (FlowNode)process.getFlowElement(targetInSpecialGatewayEndId, true);
            int nbrOfExecutionsToJoin = targetInSpecialGatewayEnd.getIncomingFlows().size();
            for (int i = 0; i < nbrOfExecutionsToJoin - 1; ++i) {
                ExecutionEntity childExecution = executionEntityManager.createChildExecution(parentExecutionEntity);
                childExecution.setCurrentFlowElement((FlowElement)targetInSpecialGatewayEnd);
                ActivityBehavior activityBehavior = (ActivityBehavior)targetInSpecialGatewayEnd.getBehavior();
                activityBehavior.execute((DelegateExecution)childExecution);
            }
        }
    }

    private List<ExecutionEntity> getRealExecutions(CommandContext commandContext, String processInstanceId, String taskExecutionId, String sourceRealActivityId, Set<String> activityIds) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext);
        ExecutionEntity taskExecution = (ExecutionEntity)executionEntityManager.findById(taskExecutionId);
        List executions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        Set parentExecutionIds = FlowableUtils.getParentExecutionIdsByActivityId((List)executions, (String)sourceRealActivityId);
        String realParentExecutionId = FlowableUtils.getParentExecutionIdFromParentIds((ExecutionEntity)taskExecution, (Set)parentExecutionIds);
        List childExecutions = executionEntityManager.findExecutionsByParentExecutionAndActivityIds(realParentExecutionId, activityIds);
        return childExecutions;
    }
}

