/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.security;

import cn.hutool.core.util.StrUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    public static final String TOKEN = "token";
    public static final String SIGN_CODE = "@#&#$^JWE@#$F123";

    public boolean validateToken(String token, String accessToken) {
        String userName = TokenProvider.getLoginName((String)accessToken);
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"@#&#$^JWE@#$F123");
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", userName).build();
            verifier.verify(accessToken);
            return true;
        }
        catch (TokenExpiredException e) {
            String newAccessToken = TokenProvider.createAccessToken((String)userName);
            RedisUtils.getInstance().set("user:cache:token", token, (Object)newAccessToken);
            RedisUtils.getInstance().expire("user:cache:token", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
            RedisUtils.getInstance().expire("user:cache:online:users", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
            return true;
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
            return false;
        }
    }

    public static String getLoginName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Authentication getAuthentication(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        String username = jwt.getClaim("username").asString();
        ArrayList authorities = new ArrayList();
        User principal = new User(username, "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public static String createAccessToken(String username) {
        Date date = new Date(System.currentTimeMillis() + JeePlusProperties.newInstance().getEXPIRE_TIME() * 1000L);
        Algorithm algorithm = Algorithm.HMAC256((String)"@#&#$^JWE@#$F123");
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static String resolveToken(ServerHttpRequest request) {
        String token0 = (String)request.getQueryParams().getFirst((Object)"token");
        String token1 = request.getHeaders().getFirst("token");
        HttpCookie token2 = (HttpCookie)request.getCookies().getFirst((Object)"token");
        if (StrUtil.isNotBlank((CharSequence)token0)) {
            return token0;
        }
        if (StrUtil.isNotBlank((CharSequence)token1)) {
            return token1;
        }
        if (token2 != null && StrUtil.isNotBlank((CharSequence)token2.getValue())) {
            return token2.getValue();
        }
        return null;
    }
}

