/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.filter;

import cn.hutool.core.util.StrUtil;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.gateway.security.TokenProvider;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class JWTFilter
implements WebFilter,
Ordered {
    private final TokenProvider tokenProvider;

    public JWTFilter(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        boolean isLogin;
        Object accessTokenObj;
        String loginName;
        String token = TokenProvider.resolveToken((ServerHttpRequest)exchange.getRequest());
        String accessToken = null;
        if (StrUtil.isNotEmpty((CharSequence)token) && StrUtil.isNotEmpty((CharSequence)(loginName = TokenProvider.getLoginName((String)token))) && (accessTokenObj = RedisUtils.getInstance().get("user:cache:token", token)) != null) {
            accessToken = accessTokenObj.toString();
            RedisUtils.getInstance().expire("user:cache:token", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
            RedisUtils.getInstance().expire("user:cache:online:users", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
        }
        boolean bl = isLogin = StrUtil.isNotBlank(accessToken) && !accessToken.equals("kickOut");
        if (isLogin && this.tokenProvider.validateToken(token, accessToken)) {
            Authentication authentication = TokenProvider.getAuthentication((String)accessToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            return chain.filter(exchange).subscriberContext(ReactiveSecurityContextHolder.withAuthentication((Authentication)authentication));
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -300;
    }
}

