/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.route.strategy;

import com.xxl.job.admin.core.route.ExecutorRouter;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExecutorRouteLFU
extends ExecutorRouter {
    private static ConcurrentMap<Integer, HashMap<String, Integer>> jobLfuMap = new ConcurrentHashMap();
    private static long CACHE_VALID_TIME = 0L;

    public String route(int jobId, List<String> addressList) {
        HashMap<String, Integer> lfuItemMap;
        if (System.currentTimeMillis() > CACHE_VALID_TIME) {
            jobLfuMap.clear();
            CACHE_VALID_TIME = System.currentTimeMillis() + 86400000L;
        }
        if ((lfuItemMap = (HashMap<String, Integer>)jobLfuMap.get(jobId)) == null) {
            lfuItemMap = new HashMap<String, Integer>();
            jobLfuMap.putIfAbsent(jobId, lfuItemMap);
        }
        for (String string : addressList) {
            if (lfuItemMap.containsKey(string) && (Integer)lfuItemMap.get(string) <= 1000000) continue;
            lfuItemMap.put(string, new Random().nextInt(addressList.size()));
        }
        ArrayList<String> delKeys = new ArrayList<String>();
        for (String existKey : lfuItemMap.keySet()) {
            if (addressList.contains(existKey)) continue;
            delKeys.add(existKey);
        }
        if (delKeys.size() > 0) {
            for (String delKey : delKeys) {
                lfuItemMap.remove(delKey);
            }
        }
        ArrayList arrayList = new ArrayList(lfuItemMap.entrySet());
        Collections.sort(arrayList, new /* Unavailable Anonymous Inner Class!! */);
        Map.Entry addressItem = (Map.Entry)arrayList.get(0);
        String minAddress = (String)addressItem.getKey();
        addressItem.setValue((Integer)addressItem.getValue() + 1);
        return (String)addressItem.getKey();
    }

    public ReturnT<String> route(TriggerParam triggerParam, List<String> addressList) {
        String address = this.route(triggerParam.getJobId(), addressList);
        return new ReturnT((Object)address);
    }
}

