/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.config;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.jeeplus.common.SecurityUtils;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.DataRuleDTO;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPermissionHandlerImpl
implements DataPermissionHandler {
    private final Logger logger = LoggerFactory.getLogger(DataPermissionHandlerImpl.class);

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        if (SecurityUtils.getCurrentUserDTO() == null || StrUtil.isBlank((CharSequence)SecurityUtils.getCurrentUserDTO().getId())) {
            return where;
        }
        List dataRuleList = ((IUserApi)SpringUtil.getBean(IUserApi.class)).getDataRuleList(SecurityUtils.getCurrentUserDTO());
        if (SecurityUtils.getCurrentUserDTO().isAdmin() || dataRuleList.size() == 0) {
            return where;
        }
        AndExpression expression = null;
        for (DataRuleDTO dataRule : dataRuleList) {
            if (!mappedStatementId.equals(dataRule.getClassName())) continue;
            try {
                if (dataRule.getValue() != null && dataRule.getValue().startsWith("@currentUser")) {
                    BeanPath resolver = new BeanPath(StrUtil.subAfter((CharSequence)dataRule.getValue(), (CharSequence)".", (boolean)false));
                    Object result = resolver.get((Object)SecurityUtils.getCurrentUserDTO());
                    dataRule.setValue(result.toString());
                }
                if (dataRule.getSqlSegment() != null) {
                    String sql = dataRule.getSqlSegment();
                    String[] objStrs = new String[]{"@currentUser.name", "@currentUser.id", "@currentUser.loginName", "@currentUser.no", "@currentUser.companyDTO.name", "@currentUser.companyDTO.id", "@currentUser.officeDTO.name", "@currentUser.officeDTO.id", "@currentUser.companyDTO.parentIds", "@currentUser.officeDTO.parentIds"};
                    for (int i = 0; i < objStrs.length; ++i) {
                        String objStr = objStrs[i];
                        if (sql.indexOf(objStr) < 0) continue;
                        BeanPath resolver = new BeanPath(StrUtil.subAfter((CharSequence)objStr, (CharSequence)".", (boolean)false));
                        Object result = resolver.get((Object)SecurityUtils.getCurrentUserDTO());
                        sql = sql.replace(objStr, "'" + result.toString() + "'");
                    }
                    dataRule.setSqlSegment(sql);
                }
                Expression condExpression = CCJSqlParserUtil.parseCondExpression((String)dataRule.getDataScopeSql());
                expression = ObjectUtils.isNotEmpty((Object)expression) ? new OrExpression((Expression)expression, condExpression) : condExpression;
            }
            catch (JSQLParserException e) {
                e.printStackTrace();
                this.logger.error("{}", (Throwable)e);
            }
        }
        if (ObjectUtils.isEmpty(expression)) {
            return where;
        }
        return ObjectUtils.isNotEmpty((Object)where) ? new AndExpression(where, (Expression)new Parenthesis((Expression)expression)) : expression;
    }
}

