/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.jeeplus.config.swagger.IgnoreSwaggerParameter;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.sys.service.dto.DataRuleDTO;
import com.jeeplus.sys.service.dto.MenuDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class RoleDTO
extends BaseDTO {
    private static final long serialVersionUID = 1L;
    @Length(min=1, max=100)
    private @Length(min=1, max=100) String name;
    @Length(min=1, max=100)
    private @Length(min=1, max=100) String enName;
    private String oldName;
    private String oldEnName;
    private String sysData;
    private String useable;
    @IgnoreSwaggerParameter
    private UserDTO userDTO;
    private String remarks;
    @JsonIgnore
    private List<MenuDTO> menuDTOList = Lists.newArrayList();
    @JsonIgnore
    private List<DataRuleDTO> dataRuleDTOList = Lists.newArrayList();

    public RoleDTO() {
    }

    public RoleDTO(String id) {
        super(id);
    }

    @JsonIgnore
    public List<String> getMenuIdList() {
        ArrayList menuIdList = Lists.newArrayList();
        for (MenuDTO menu : this.menuDTOList) {
            menuIdList.add(menu.getId());
        }
        return menuIdList;
    }

    public void setMenuIdList(List<String> menuIdList) {
        this.menuDTOList = Lists.newArrayList();
        for (String menuId : menuIdList) {
            MenuDTO menuDTO = new MenuDTO();
            menuDTO.setId(menuId);
            this.menuDTOList.add(menuDTO);
        }
    }

    public String getMenuIds() {
        return StringUtils.join(this.getMenuIdList(), (String)",");
    }

    public void setMenuIds(String menuIds) {
        this.menuDTOList = Lists.newArrayList();
        if (menuIds != null) {
            Object[] ids = StringUtils.split((String)menuIds, (String)",");
            this.setMenuIdList(Lists.newArrayList((Object[])ids));
        }
    }

    public List<String> getPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (MenuDTO menuDTO : this.menuDTOList) {
            if (menuDTO.getPermission() == null || "".equals(menuDTO.getPermission())) continue;
            permissions.add(menuDTO.getPermission());
        }
        return permissions;
    }

    @JsonIgnore
    public List<String> getDataRuleIdList() {
        ArrayList dataRuleIdList = Lists.newArrayList();
        for (DataRuleDTO dataRule : this.dataRuleDTOList) {
            dataRuleIdList.add(dataRule.getId());
        }
        return dataRuleIdList;
    }

    public void setDataRuleIdList(List<String> dataRuleIdList) {
        this.dataRuleDTOList = Lists.newArrayList();
        for (String dataRuleId : dataRuleIdList) {
            DataRuleDTO dataRuleDTO = new DataRuleDTO();
            dataRuleDTO.setId(dataRuleId);
            this.dataRuleDTOList.add(dataRuleDTO);
        }
    }

    public String getDataRuleIds() {
        return StringUtils.join(this.getDataRuleIdList(), (String)",");
    }

    public void setDataRuleIds(String dataRuleIds) {
        this.dataRuleDTOList = Lists.newArrayList();
        if (dataRuleIds != null) {
            Object[] ids = StringUtils.split((String)dataRuleIds, (String)",");
            this.setDataRuleIdList(Lists.newArrayList((Object[])ids));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEnName() {
        return this.enName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getOldEnName() {
        return this.oldEnName;
    }

    public String getSysData() {
        return this.sysData;
    }

    public String getUseable() {
        return this.useable;
    }

    public UserDTO getUserDTO() {
        return this.userDTO;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public List<MenuDTO> getMenuDTOList() {
        return this.menuDTOList;
    }

    public List<DataRuleDTO> getDataRuleDTOList() {
        return this.dataRuleDTOList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public void setOldEnName(String oldEnName) {
        this.oldEnName = oldEnName;
    }

    public void setSysData(String sysData) {
        this.sysData = sysData;
    }

    public void setUseable(String useable) {
        this.useable = useable;
    }

    public void setUserDTO(UserDTO userDTO) {
        this.userDTO = userDTO;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @JsonIgnore
    public void setMenuDTOList(List<MenuDTO> menuDTOList) {
        this.menuDTOList = menuDTOList;
    }

    @JsonIgnore
    public void setDataRuleDTOList(List<DataRuleDTO> dataRuleDTOList) {
        this.dataRuleDTOList = dataRuleDTOList;
    }

    @Override
    public String toString() {
        return "RoleDTO(name=" + this.getName() + ", enName=" + this.getEnName() + ", oldName=" + this.getOldName() + ", oldEnName=" + this.getOldEnName() + ", sysData=" + this.getSysData() + ", useable=" + this.getUseable() + ", userDTO=" + this.getUserDTO() + ", remarks=" + this.getRemarks() + ", menuDTOList=" + this.getMenuDTOList() + ", dataRuleDTOList=" + this.getDataRuleDTOList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleDTO)) {
            return false;
        }
        RoleDTO other = (RoleDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$enName = this.getEnName();
        String other$enName = other.getEnName();
        if (this$enName == null ? other$enName != null : !this$enName.equals(other$enName)) {
            return false;
        }
        String this$oldName = this.getOldName();
        String other$oldName = other.getOldName();
        if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
            return false;
        }
        String this$oldEnName = this.getOldEnName();
        String other$oldEnName = other.getOldEnName();
        if (this$oldEnName == null ? other$oldEnName != null : !this$oldEnName.equals(other$oldEnName)) {
            return false;
        }
        String this$sysData = this.getSysData();
        String other$sysData = other.getSysData();
        if (this$sysData == null ? other$sysData != null : !this$sysData.equals(other$sysData)) {
            return false;
        }
        String this$useable = this.getUseable();
        String other$useable = other.getUseable();
        if (this$useable == null ? other$useable != null : !this$useable.equals(other$useable)) {
            return false;
        }
        UserDTO this$userDTO = this.getUserDTO();
        UserDTO other$userDTO = other.getUserDTO();
        if (this$userDTO == null ? other$userDTO != null : !((Object)this$userDTO).equals(other$userDTO)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        List<MenuDTO> this$menuDTOList = this.getMenuDTOList();
        List<MenuDTO> other$menuDTOList = other.getMenuDTOList();
        if (this$menuDTOList == null ? other$menuDTOList != null : !((Object)this$menuDTOList).equals(other$menuDTOList)) {
            return false;
        }
        List<DataRuleDTO> this$dataRuleDTOList = this.getDataRuleDTOList();
        List<DataRuleDTO> other$dataRuleDTOList = other.getDataRuleDTOList();
        return !(this$dataRuleDTOList == null ? other$dataRuleDTOList != null : !((Object)this$dataRuleDTOList).equals(other$dataRuleDTOList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RoleDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $enName = this.getEnName();
        result = result * 59 + ($enName == null ? 43 : $enName.hashCode());
        String $oldName = this.getOldName();
        result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
        String $oldEnName = this.getOldEnName();
        result = result * 59 + ($oldEnName == null ? 43 : $oldEnName.hashCode());
        String $sysData = this.getSysData();
        result = result * 59 + ($sysData == null ? 43 : $sysData.hashCode());
        String $useable = this.getUseable();
        result = result * 59 + ($useable == null ? 43 : $useable.hashCode());
        UserDTO $userDTO = this.getUserDTO();
        result = result * 59 + ($userDTO == null ? 43 : ((Object)$userDTO).hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        List<MenuDTO> $menuDTOList = this.getMenuDTOList();
        result = result * 59 + ($menuDTOList == null ? 43 : ((Object)$menuDTOList).hashCode());
        List<DataRuleDTO> $dataRuleDTOList = this.getDataRuleDTOList();
        result = result * 59 + ($dataRuleDTOList == null ? 43 : ((Object)$dataRuleDTOList).hashCode());
        return result;
    }
}

