/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.extension.controller;

import com.google.common.collect.Lists;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.dto.DragNode;
import com.jeeplus.extension.domain.ActCategory;
import com.jeeplus.extension.service.ActCategoryService;
import com.jeeplus.extension.service.dto.ActCategoryDTO;
import com.jeeplus.extension.service.mapstruct.ActCategoryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/extension/actCategory"})
public class ActCategoryController {
    @Autowired
    private ActCategoryService actCategoryService;
    @Autowired
    private ActCategoryWrapper actCategoryWrapper;

    @GetMapping(value={"list"})
    public ResponseEntity list() {
        return ResponseEntity.ok((Object)this.actCategoryService.list());
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(String id) {
        return ResponseEntity.ok((Object)this.actCategoryWrapper.toDTO(this.actCategoryService.getById((Serializable)((Object)id))));
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody @Valid ActCategoryDTO actCategoryDTO) {
        ActCategory actCategory = (ActCategory)this.actCategoryWrapper.toEntity((Object)actCategoryDTO);
        this.actCategoryService.saveOrUpdate((TreeEntity)actCategory);
        return ResponseEntity.ok((Object)actCategory);
    }

    @PostMapping(value={"drag"})
    public ResponseEntity drag(@Valid @RequestBody DragNode<ActCategory> dragDTO) {
        this.actCategoryService.sortList(dragDTO);
        return ResponseEntity.ok((Object)"\u79fb\u52a8\u8282\u70b9\u6210\u529f!");
    }

    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        Object[] idArray = ids.split(",");
        this.actCategoryService.removeByIds((Collection)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u6d41\u7a0b\u5206\u7c7b\u6210\u529f");
    }

    @GetMapping(value={"treeData"})
    public ResponseEntity treeData(@RequestParam(required=false) String extId) {
        List list = this.actCategoryService.treeData(extId);
        return ResponseEntity.ok((Object)list);
    }
}

