/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.cron.CronExpression;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.scheduler.ScheduleTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobScheduleHelper {
    private static Logger logger = LoggerFactory.getLogger(JobScheduleHelper.class);
    private static JobScheduleHelper instance = new JobScheduleHelper();
    public static final long PRE_READ_MS = 5000L;
    private Thread scheduleThread;
    private Thread ringThread;
    private volatile boolean scheduleThreadToStop = false;
    private volatile boolean ringThreadToStop = false;
    private static volatile Map<Integer, List<Integer>> ringData = new ConcurrentHashMap();

    public static JobScheduleHelper getInstance() {
        return instance;
    }

    public void start() {
        this.scheduleThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.scheduleThread.setDaemon(true);
        this.scheduleThread.setName("xxl-job, admin JobScheduleHelper#scheduleThread");
        this.scheduleThread.start();
        this.ringThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.ringThread.setDaemon(true);
        this.ringThread.setName("xxl-job, admin JobScheduleHelper#ringThread");
        this.ringThread.start();
    }

    private void refreshNextValidTime(XxlJobInfo jobInfo, Date fromTime) throws Exception {
        Date nextValidTime = JobScheduleHelper.generateNextValidTime((XxlJobInfo)jobInfo, (Date)fromTime);
        if (nextValidTime != null) {
            jobInfo.setTriggerLastTime(jobInfo.getTriggerNextTime());
            jobInfo.setTriggerNextTime(nextValidTime.getTime());
        } else {
            jobInfo.setTriggerStatus(0);
            jobInfo.setTriggerLastTime(0L);
            jobInfo.setTriggerNextTime(0L);
            logger.warn(">>>>>>>>>>> xxl-job, refreshNextValidTime fail for job: jobId={}, scheduleType={}, scheduleConf={}", new Object[]{jobInfo.getId(), jobInfo.getScheduleType(), jobInfo.getScheduleConf()});
        }
    }

    private void pushTimeRing(int ringSecond, int jobId) {
        ArrayList<Integer> ringItemData = (ArrayList<Integer>)ringData.get(ringSecond);
        if (ringItemData == null) {
            ringItemData = new ArrayList<Integer>();
            ringData.put(ringSecond, ringItemData);
        }
        ringItemData.add(jobId);
        logger.debug(">>>>>>>>>>> xxl-job, schedule push time-ring : " + ringSecond + " = " + Arrays.asList(ringItemData));
    }

    public void toStop() {
        this.scheduleThreadToStop = true;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.scheduleThread.getState() != Thread.State.TERMINATED) {
            this.scheduleThread.interrupt();
            try {
                this.scheduleThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        boolean hasRingData = false;
        if (!ringData.isEmpty()) {
            Iterator iterator = ringData.keySet().iterator();
            while (iterator.hasNext()) {
                int second = (Integer)iterator.next();
                List tmpData = (List)ringData.get(second);
                if (tmpData == null || tmpData.size() <= 0) continue;
                hasRingData = true;
                break;
            }
        }
        if (hasRingData) {
            try {
                TimeUnit.SECONDS.sleep(8L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.ringThreadToStop = true;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.ringThread.getState() != Thread.State.TERMINATED) {
            this.ringThread.interrupt();
            try {
                this.ringThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info(">>>>>>>>>>> xxl-job, JobScheduleHelper stop");
    }

    public static Date generateNextValidTime(XxlJobInfo jobInfo, Date fromTime) throws Exception {
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match((String)jobInfo.getScheduleType(), null);
        if (ScheduleTypeEnum.CRON == scheduleTypeEnum) {
            Date nextValidTime = new CronExpression(jobInfo.getScheduleConf()).getNextValidTimeAfter(fromTime);
            return nextValidTime;
        }
        if (ScheduleTypeEnum.FIX_RATE == scheduleTypeEnum) {
            return new Date(fromTime.getTime() + (long)(Integer.valueOf(jobInfo.getScheduleConf()) * 1000));
        }
        return null;
    }

    static /* synthetic */ boolean access$000(JobScheduleHelper x0) {
        return x0.scheduleThreadToStop;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ void access$200(JobScheduleHelper x0, XxlJobInfo x1, Date x2) throws Exception {
        x0.refreshNextValidTime(x1, x2);
    }

    static /* synthetic */ void access$300(JobScheduleHelper x0, int x1, int x2) {
        x0.pushTimeRing(x1, x2);
    }

    static /* synthetic */ boolean access$400(JobScheduleHelper x0) {
        return x0.ringThreadToStop;
    }

    static /* synthetic */ Map access$500() {
        return ringData;
    }
}

