/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.repository;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.jeeplus.common.utils.CommonUtils;
import com.jeeplus.file.repository.AccessoryRepository;
import com.jeeplus.file.utils.FileUtils;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.http.Method;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"config.accessory.type"}, havingValue="minIO")
public class MinIORepository
implements AccessoryRepository {
    private static final Logger log = LoggerFactory.getLogger(MinIORepository.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${config.accessory.baseDir}")
    private String accessoryBaseDir;
    @Value(value="${config.accessory.minIO.endpoint}")
    private String endpoint;
    @Value(value="${config.accessory.minIO.accessKey}")
    private String accessKey;
    @Value(value="${config.accessory.minIO.secretKey}")
    private String secretKey;
    @Value(value="${config.accessory.minIO.bucketName}")
    private String bucketName;

    public File get(String path, String fileName) throws FileNotFoundException {
        this.logger.debug("\u5f00\u59cb\u4eceminIO-oss\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{path, "/", fileName});
        long begin = System.currentTimeMillis();
        try {
            if (path == null) {
                path = "";
            }
            MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
            GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(this.accessoryBaseDir + "/" + path + "/" + fileName)).build();
            GetObjectResponse is = client.getObject(objectArgs);
            File localTempDir = new File(FileUtils.getTempDirectory() + File.separator + this.accessoryBaseDir + File.separator + path);
            FileUtils.createDirectory((String)localTempDir.getPath());
            File dest = new File(localTempDir, fileName);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
            is.close();
            File file = dest;
            return file;
        }
        catch (Exception e) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4eceminIO-oss\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
    }

    public String getURL(String path, String fileName, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        this.logger.debug("\u5f00\u59cb\u4eceminIO-oss\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{path, "/", fileName});
        long begin = System.currentTimeMillis();
        Object downloadURL = null;
        try {
            String url;
            if (path == null) {
                path = "";
            }
            MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
            String string = url = client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)new GetPresignedObjectUrlArgs.Builder().bucket(this.bucketName)).object(this.accessoryBaseDir + "/" + path + "/" + fileName)).expiry(1, TimeUnit.DAYS).method(Method.GET).build());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4eceminIO-oss\u83b7\u53d6\u6587\u4ef6\u4e34\u65f6\u6388\u6743\u8def\u5f84 {}, \u8017\u65f6: {}", downloadURL, (Object)(System.currentTimeMillis() - begin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File save(File file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        try {
            MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
            boolean exists = client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucketName)).build());
            if (!exists) {
                client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucketName)).build());
            }
            FileInputStream in = new FileInputStream(file);
            String mime = FileUtil.getMimeType((String)file.getName());
            if (mime == null) {
                mime = "application/octet-stream";
            }
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(this.accessoryBaseDir + "/" + path + "/" + fileName)).stream((InputStream)in, file.length(), -1L).contentType(mime).build();
            client.putObject(putObjectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
        return file;
    }

    public File save(MultipartFile file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        try {
            MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
            boolean exists = client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucketName)).build());
            if (!exists) {
                client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucketName)).build());
            }
            InputStream is = file.getInputStream();
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).contentType(file.getContentType()).object(this.accessoryBaseDir + "/" + path + "/" + fileName)).stream(is, (long)is.available(), -1L).build();
            client.putObject(putObjectArgs);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5b8c\u6210\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return null;
    }

    public File save(InputStream is, String path, @NotNull String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        try {
            MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
            boolean exists = client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucketName)).build());
            if (!exists) {
                client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucketName)).build());
            }
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(this.accessoryBaseDir + "/" + path + "/" + fileName)).stream(is, (long)is.available(), -1L).build();
            client.putObject(putObjectArgs);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5b8c\u6210\u5411minIO-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return null;
    }

    public String writeByUrl(MultipartFile file, String url) {
        url = this.endpoint.endsWith("/") ? url.replace(this.endpoint, "") : url.replace(this.endpoint + "/", "");
        String customBucket = url.split("/")[0];
        String bizPath = url.replace(customBucket + "/", "");
        String filename = bizPath.substring(bizPath.lastIndexOf("/") + 1);
        bizPath = bizPath.substring(0, bizPath.lastIndexOf("/"));
        return this.upload(file, bizPath, customBucket, filename, true);
    }

    private String upload(MultipartFile file, String bizPath, String customBucket, String fileName, boolean isWrite) {
        String file_url = "";
        String newBucket = this.bucketName;
        if (StrUtil.isNotEmpty((CharSequence)customBucket)) {
            newBucket = customBucket;
        }
        MinioClient minioClient = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
        try {
            String orgName;
            if (minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build())) {
                log.info("Bucket already exists.");
            } else {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build());
                minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().config("{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetBucketLocation\",\"s3:ListBucket\",\"s3:ListBucketMultipartUploads\"],\"Resource\":[\"arn:aws:s3:::" + newBucket + "\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetObject\",\"s3:ListMultipartUploadParts\",\"s3:PutObject\",\"s3:AbortMultipartUpload\",\"s3:DeleteObject\"],\"Resource\":[\"arn:aws:s3:::" + newBucket + "/*\"]}]}").bucket(newBucket)).build());
                log.info("create a new bucket.");
            }
            InputStream stream = file.getInputStream();
            if (StrUtil.isNotBlank((CharSequence)fileName)) {
                orgName = fileName;
            } else {
                orgName = file.getOriginalFilename();
                orgName = CommonUtils.getFileName((String)orgName);
            }
            String objectName = !isWrite ? bizPath + "/" + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf(".")) : bizPath + "/" + orgName;
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(newBucket)).object(objectName)).stream(stream, (long)stream.available(), -1L).build();
            minioClient.putObject(putObjectArgs);
            stream.close();
            file_url = newBucket + "/" + objectName;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        file_url = file_url.startsWith("/") ? file_url : "/" + file_url;
        return file_url;
    }
}

