/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.shop.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.common.excel.EasyExcelUtils;
import com.jeeplus.common.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.logging.annotation.ApiLog;
import com.jeeplus.test.shop.service.TestGoodsService;
import com.jeeplus.test.shop.service.dto.TestGoodsDTO;
import com.jeeplus.test.shop.service.mapstruct.TestGoodsWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5546\u54c1"})
@RestController
@RequestMapping(value={"/test/shop/testGoods"})
public class TestGoodsController {
    @Autowired
    private TestGoodsService testGoodsService;
    @Autowired
    private TestGoodsWrapper testGoodsWrapper;

    @ApiLog(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('test:shop:testGoods:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<TestGoodsDTO>> list(TestGoodsDTO testGoodsDTO, Page<TestGoodsDTO> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)testGoodsDTO, TestGoodsDTO.class);
        IPage result = this.testGoodsService.findPage(page, queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:shop:testGoods:view','test:shop:testGoods:add','test:shop:testGoods:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<TestGoodsDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.testGoodsService.findById(id));
    }

    @ApiLog(value="\u4fdd\u5b58\u5546\u54c1")
    @ApiOperation(value="\u4fdd\u5b58\u5546\u54c1")
    @PreAuthorize(value="hasAnyAuthority('test:shop:testGoods:add','test:shop:testGoods:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody TestGoodsDTO testGoodsDTO) {
        this.testGoodsService.saveOrUpdate((Object)this.testGoodsWrapper.toEntity(testGoodsDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5546\u54c1\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u5546\u54c1")
    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @PreAuthorize(value="hasAuthority('test:shop:testGoods:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.testGoodsService.removeByIds((Collection)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5546\u54c1\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u5546\u54c1\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:shop:testGoods:export')")
    @GetMapping(value={"export"})
    public void exportFile(TestGoodsDTO testGoodsDTO, Page<TestGoodsDTO> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)testGoodsDTO, TestGoodsDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"a.id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = this.testGoodsService.findPage(page, queryWrapper).getRecords();
        EasyExcelUtils.newInstance((IService)this.testGoodsService, (EntityWrapper)this.testGoodsWrapper).exportExcel(result, options.getSheetName(), TestGoodsDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('test:shop:testGoods:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.testGoodsService, (EntityWrapper)this.testGoodsWrapper).importExcel(file, TestGoodsDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('test:shop:testGoods:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u5546\u54c1\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.testGoodsService, (EntityWrapper)this.testGoodsWrapper).exportExcel((List)list, "\u5546\u54c1\u6570\u636e", TestGoodsDTO.class, fileName, null, response);
    }
}

