/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.service.dto;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.jeeplus.common.excel.annotation.ExcelDictProperty;
import com.jeeplus.config.swagger.IgnoreSwaggerParameter;
import com.jeeplus.core.excel.converter.ExcelDictDTOConverter;
import com.jeeplus.core.excel.converter.ExcelOfficeDTOConverter;
import com.jeeplus.core.excel.converter.ExcelPostListDTOConverter;
import com.jeeplus.core.excel.converter.ExcelRoleListDTOConverter;
import com.jeeplus.core.query.Query;
import com.jeeplus.core.query.QueryType;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.sys.feign.ITenantApi;
import com.jeeplus.sys.service.dto.OfficeDTO;
import com.jeeplus.sys.service.dto.PostDTO;
import com.jeeplus.sys.service.dto.RoleDTO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

public class UserDTO
extends BaseDTO {
    private static final long serialVersionUID = 1L;
    @Length(min=1, max=100)
    @Query
    @ExcelProperty(value={"\u767b\u5f55\u540d"})
    private @Length(min=1, max=100) String loginName;
    @Length(min=1, max=100)
    @ExcelIgnore
    private @Length(min=1, max=100) String password;
    @Length(min=1, max=100)
    @Query(tableColumn="a.name")
    @ExcelProperty(value={"\u59d3\u540d"})
    private @Length(min=1, max=100) String name;
    @Length(min=1, max=100)
    @ExcelProperty(value={"\u5de5\u53f7"})
    private @Length(min=1, max=100) String no;
    @NotNull(message="\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a")
    @Query(type=QueryType.EQ, tableColumn="c.id", javaField="companyDTO.id")
    @IgnoreSwaggerParameter
    @ExcelProperty(value={"\u516c\u53f8"}, converter=ExcelOfficeDTOConverter.class)
    private @NotNull(message="\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a") OfficeDTO companyDTO;
    @NotNull(message="\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a")
    @Query(type=QueryType.EQ, tableColumn="o.id", javaField="officeDTO.id")
    @IgnoreSwaggerParameter
    @ExcelProperty(value={"\u90e8\u95e8"}, converter=ExcelOfficeDTOConverter.class)
    private @NotNull(message="\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a") OfficeDTO officeDTO;
    @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e")
    @Length(min=0, max=100)
    @ExcelProperty(value={"\u90ae\u7bb1"})
    private @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e") @Length(min=0, max=100) String email;
    @Length(min=0, max=100)
    @ExcelProperty(value={"\u7535\u8bdd"})
    private @Length(min=0, max=100) String phone;
    @Length(min=0, max=100)
    @ExcelProperty(value={"\u624b\u673a"})
    private @Length(min=0, max=100) String mobile;
    @IgnoreSwaggerParameter
    @ExcelIgnore
    private String loginIp;
    @IgnoreSwaggerParameter
    @ExcelIgnore
    private Date loginDate;
    @ExcelProperty(value={"\u662f\u5426\u5141\u8bb8\u767b\u5f55"}, converter=ExcelDictDTOConverter.class)
    @ExcelDictProperty(value="yes_no")
    private String loginFlag;
    @ExcelIgnore
    private String photo;
    @ExcelIgnore
    private String qrCode;
    @ExcelIgnore
    private String oldLoginName;
    @ExcelIgnore
    private String newPassword;
    @ExcelIgnore
    private String sign;
    @ExcelIgnore
    private String token;
    @ExcelProperty(value={"\u5907\u6ce8"})
    private String remarks;
    @ExcelIgnore
    private boolean isAdmin;
    @Query(type=QueryType.EQ, javaField="roleDTO.id", tableColumn="r.id")
    @IgnoreSwaggerParameter
    @ExcelIgnore
    private RoleDTO roleDTO;
    @ExcelIgnore
    @Query(type=QueryType.EQ, javaField="postDTO.id", tableColumn="p.id")
    private PostDTO postDTO;
    @IgnoreSwaggerParameter
    @JsonIgnore
    @ExcelProperty(value={"\u89d2\u8272"}, converter=ExcelRoleListDTOConverter.class)
    private List<RoleDTO> roleDTOList = Lists.newArrayList();
    @IgnoreSwaggerParameter
    @JsonIgnore
    @ExcelProperty(value={"\u5c97\u4f4d"}, converter=ExcelPostListDTOConverter.class)
    private List<PostDTO> postDTOList = Lists.newArrayList();

    public UserDTO() {
    }

    public UserDTO(String id) {
        super(id);
    }

    public List<String> getRoleIdList() {
        if (this.roleDTOList == null) {
            return Lists.newArrayList();
        }
        List<String> roleIdList = this.roleDTOList.stream().map(roleDTO -> roleDTO.getId()).collect(Collectors.toList());
        return roleIdList;
    }

    public void setRoleIdList(List<String> roleIdList) {
        for (String roleId : roleIdList) {
            RoleDTO roleDTO = new RoleDTO(roleId);
            this.roleDTOList.add(roleDTO);
        }
    }

    public List<String> getPostIdList() {
        if (this.postDTOList == null) {
            return Lists.newArrayList();
        }
        List<String> postIdList = this.postDTOList.stream().map(postDTO -> postDTO.getId()).collect(Collectors.toList());
        return postIdList;
    }

    public void setPostIdList(List<String> postIdList) {
        for (String postId : postIdList) {
            PostDTO postDTO = new PostDTO(postId);
            this.postDTOList.add(postDTO);
        }
    }

    public String getRoleNames() {
        List roleNames = this.roleDTOList.stream().map(roleDTO -> roleDTO.getName()).collect(Collectors.toList());
        return StrUtil.join((CharSequence)",", roleNames);
    }

    public String getRoleIds() {
        List roleIds = this.roleDTOList.stream().map(roleDTO -> roleDTO.getId()).collect(Collectors.toList());
        return StrUtil.join((CharSequence)",", roleIds);
    }

    public String getIdCacheKey() {
        return this.getId();
    }

    public String getLoginNameCacheKey() {
        String tenantId = this.getTenantDTO() != null ? this.getTenantDTO().getId() : ((ITenantApi)SpringUtil.getBean(ITenantApi.class)).getCurrentTenantId();
        return tenantId + ":" + this.getLoginName();
    }

    public String getOldLoginNameCacheKey() {
        String tenantId = this.getTenantDTO() != null ? this.getTenantDTO().getId() : ((ITenantApi)SpringUtil.getBean(ITenantApi.class)).getCurrentTenantId();
        return tenantId + ":" + this.getOldLoginName();
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getNo() {
        return this.no;
    }

    public OfficeDTO getCompanyDTO() {
        return this.companyDTO;
    }

    public OfficeDTO getOfficeDTO() {
        return this.officeDTO;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public Date getLoginDate() {
        return this.loginDate;
    }

    public String getLoginFlag() {
        return this.loginFlag;
    }

    public String getPhoto() {
        return this.photo;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public String getOldLoginName() {
        return this.oldLoginName;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getSign() {
        return this.sign;
    }

    public String getToken() {
        return this.token;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public RoleDTO getRoleDTO() {
        return this.roleDTO;
    }

    public PostDTO getPostDTO() {
        return this.postDTO;
    }

    public List<RoleDTO> getRoleDTOList() {
        return this.roleDTOList;
    }

    public List<PostDTO> getPostDTOList() {
        return this.postDTOList;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public void setCompanyDTO(OfficeDTO companyDTO) {
        this.companyDTO = companyDTO;
    }

    public void setOfficeDTO(OfficeDTO officeDTO) {
        this.officeDTO = officeDTO;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public void setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
    }

    public void setLoginFlag(String loginFlag) {
        this.loginFlag = loginFlag;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public void setOldLoginName(String oldLoginName) {
        this.oldLoginName = oldLoginName;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setRoleDTO(RoleDTO roleDTO) {
        this.roleDTO = roleDTO;
    }

    public void setPostDTO(PostDTO postDTO) {
        this.postDTO = postDTO;
    }

    @JsonIgnore
    public void setRoleDTOList(List<RoleDTO> roleDTOList) {
        this.roleDTOList = roleDTOList;
    }

    @JsonIgnore
    public void setPostDTOList(List<PostDTO> postDTOList) {
        this.postDTOList = postDTOList;
    }

    @Override
    public String toString() {
        return "UserDTO(loginName=" + this.getLoginName() + ", password=" + this.getPassword() + ", name=" + this.getName() + ", no=" + this.getNo() + ", companyDTO=" + this.getCompanyDTO() + ", officeDTO=" + this.getOfficeDTO() + ", email=" + this.getEmail() + ", phone=" + this.getPhone() + ", mobile=" + this.getMobile() + ", loginIp=" + this.getLoginIp() + ", loginDate=" + this.getLoginDate() + ", loginFlag=" + this.getLoginFlag() + ", photo=" + this.getPhoto() + ", qrCode=" + this.getQrCode() + ", oldLoginName=" + this.getOldLoginName() + ", newPassword=" + this.getNewPassword() + ", sign=" + this.getSign() + ", token=" + this.getToken() + ", remarks=" + this.getRemarks() + ", isAdmin=" + this.isAdmin() + ", roleDTO=" + this.getRoleDTO() + ", postDTO=" + this.getPostDTO() + ", roleDTOList=" + this.getRoleDTOList() + ", postDTOList=" + this.getPostDTOList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserDTO)) {
            return false;
        }
        UserDTO other = (UserDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        String this$loginName = this.getLoginName();
        String other$loginName = other.getLoginName();
        if (this$loginName == null ? other$loginName != null : !this$loginName.equals(other$loginName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$no = this.getNo();
        String other$no = other.getNo();
        if (this$no == null ? other$no != null : !this$no.equals(other$no)) {
            return false;
        }
        OfficeDTO this$companyDTO = this.getCompanyDTO();
        OfficeDTO other$companyDTO = other.getCompanyDTO();
        if (this$companyDTO == null ? other$companyDTO != null : !((Object)this$companyDTO).equals(other$companyDTO)) {
            return false;
        }
        OfficeDTO this$officeDTO = this.getOfficeDTO();
        OfficeDTO other$officeDTO = other.getOfficeDTO();
        if (this$officeDTO == null ? other$officeDTO != null : !((Object)this$officeDTO).equals(other$officeDTO)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$loginIp = this.getLoginIp();
        String other$loginIp = other.getLoginIp();
        if (this$loginIp == null ? other$loginIp != null : !this$loginIp.equals(other$loginIp)) {
            return false;
        }
        Date this$loginDate = this.getLoginDate();
        Date other$loginDate = other.getLoginDate();
        if (this$loginDate == null ? other$loginDate != null : !((Object)this$loginDate).equals(other$loginDate)) {
            return false;
        }
        String this$loginFlag = this.getLoginFlag();
        String other$loginFlag = other.getLoginFlag();
        if (this$loginFlag == null ? other$loginFlag != null : !this$loginFlag.equals(other$loginFlag)) {
            return false;
        }
        String this$photo = this.getPhoto();
        String other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !this$photo.equals(other$photo)) {
            return false;
        }
        String this$qrCode = this.getQrCode();
        String other$qrCode = other.getQrCode();
        if (this$qrCode == null ? other$qrCode != null : !this$qrCode.equals(other$qrCode)) {
            return false;
        }
        String this$oldLoginName = this.getOldLoginName();
        String other$oldLoginName = other.getOldLoginName();
        if (this$oldLoginName == null ? other$oldLoginName != null : !this$oldLoginName.equals(other$oldLoginName)) {
            return false;
        }
        String this$newPassword = this.getNewPassword();
        String other$newPassword = other.getNewPassword();
        if (this$newPassword == null ? other$newPassword != null : !this$newPassword.equals(other$newPassword)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        RoleDTO this$roleDTO = this.getRoleDTO();
        RoleDTO other$roleDTO = other.getRoleDTO();
        if (this$roleDTO == null ? other$roleDTO != null : !((Object)this$roleDTO).equals(other$roleDTO)) {
            return false;
        }
        PostDTO this$postDTO = this.getPostDTO();
        PostDTO other$postDTO = other.getPostDTO();
        if (this$postDTO == null ? other$postDTO != null : !((Object)this$postDTO).equals(other$postDTO)) {
            return false;
        }
        List<RoleDTO> this$roleDTOList = this.getRoleDTOList();
        List<RoleDTO> other$roleDTOList = other.getRoleDTOList();
        if (this$roleDTOList == null ? other$roleDTOList != null : !((Object)this$roleDTOList).equals(other$roleDTOList)) {
            return false;
        }
        List<PostDTO> this$postDTOList = this.getPostDTOList();
        List<PostDTO> other$postDTOList = other.getPostDTOList();
        return !(this$postDTOList == null ? other$postDTOList != null : !((Object)this$postDTOList).equals(other$postDTOList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        String $loginName = this.getLoginName();
        result = result * 59 + ($loginName == null ? 43 : $loginName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $no = this.getNo();
        result = result * 59 + ($no == null ? 43 : $no.hashCode());
        OfficeDTO $companyDTO = this.getCompanyDTO();
        result = result * 59 + ($companyDTO == null ? 43 : ((Object)$companyDTO).hashCode());
        OfficeDTO $officeDTO = this.getOfficeDTO();
        result = result * 59 + ($officeDTO == null ? 43 : ((Object)$officeDTO).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $loginIp = this.getLoginIp();
        result = result * 59 + ($loginIp == null ? 43 : $loginIp.hashCode());
        Date $loginDate = this.getLoginDate();
        result = result * 59 + ($loginDate == null ? 43 : ((Object)$loginDate).hashCode());
        String $loginFlag = this.getLoginFlag();
        result = result * 59 + ($loginFlag == null ? 43 : $loginFlag.hashCode());
        String $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : $photo.hashCode());
        String $qrCode = this.getQrCode();
        result = result * 59 + ($qrCode == null ? 43 : $qrCode.hashCode());
        String $oldLoginName = this.getOldLoginName();
        result = result * 59 + ($oldLoginName == null ? 43 : $oldLoginName.hashCode());
        String $newPassword = this.getNewPassword();
        result = result * 59 + ($newPassword == null ? 43 : $newPassword.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        RoleDTO $roleDTO = this.getRoleDTO();
        result = result * 59 + ($roleDTO == null ? 43 : ((Object)$roleDTO).hashCode());
        PostDTO $postDTO = this.getPostDTO();
        result = result * 59 + ($postDTO == null ? 43 : ((Object)$postDTO).hashCode());
        List<RoleDTO> $roleDTOList = this.getRoleDTOList();
        result = result * 59 + ($roleDTOList == null ? 43 : ((Object)$roleDTOList).hashCode());
        List<PostDTO> $postDTOList = this.getPostDTOList();
        result = result * 59 + ($postDTOList == null ? 43 : ((Object)$postDTOList).hashCode());
        return result;
    }
}

