/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.treetable.controller;

import com.google.common.collect.Lists;
import com.jeeplus.core.dto.DragNode;
import com.jeeplus.logging.annotation.ApiLog;
import com.jeeplus.test.treetable.domain.TestCarKind;
import com.jeeplus.test.treetable.service.TestCarKindService;
import com.jeeplus.test.treetable.service.dto.TestCarKindDTO;
import com.jeeplus.test.treetable.service.mapstruct.TestCarKindWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f66\u7cfb"})
@RestController
@RequestMapping(value={"/test/treetable/testCarKind"})
public class TestCarKindController {
    @Autowired
    private TestCarKindService testCarKindService;
    @Autowired
    private TestCarKindWrapper testCarKindWrapper;

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u8f66\u7cfb\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u8f66\u7cfb\u6570\u636e")
    @GetMapping(value={"queryById"})
    public ResponseEntity<TestCarKindDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.testCarKindWrapper.toDTO(this.testCarKindService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u8f66\u7cfb")
    @ApiOperation(value="\u4fdd\u5b58\u8f66\u7cfb")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody TestCarKindDTO testCarKindDTO) {
        this.testCarKindService.saveOrUpdate((TestCarKind)this.testCarKindWrapper.toEntity((Object)testCarKindDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u8f66\u8f86\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u8f66\u7cfb")
    @ApiOperation(value="\u5220\u9664\u8f66\u7cfb")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.testCarKindService.removeWithChildrenByIds((List)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u8f66\u8f86\u6210\u529f");
    }

    @PostMapping(value={"drag"})
    public ResponseEntity drag(@Valid @RequestBody DragNode<TestCarKindDTO> testCarKindDTO) {
        this.testCarKindService.sortList(this.testCarKindWrapper.toEntity(testCarKindDTO));
        return ResponseEntity.ok((Object)"\u79fb\u52a8\u8282\u70b9\u6210\u529f!");
    }

    @ApiLog(value="\u67e5\u8be2\u8f66\u7cfb\u6811\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u8f66\u7cfb\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<TestCarKindDTO>> treeData(String extId) {
        List rootTree = this.testCarKindService.treeData(extId).stream().map(arg_0 -> ((TestCarKindWrapper)this.testCarKindWrapper).toDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(rootTree);
    }
}

