/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.controller.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jeeplus.flowable.controller.FlowableTaskController;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.repository.Model;
import org.flowable.image.impl.DefaultProcessDiagramGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class AppFlowableChartController
extends FlowableTaskController {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;

    @RequestMapping(value={"getAppFlowChart/{procDefId}/{procInsId}"})
    public void getJpgActivityDiagram(@PathVariable(value="procDefId") String procDefId, @PathVariable(value="procInsId") String procInsId, HttpServletResponse response) {
        List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procInsId).orderByHistoricActivityInstanceStartTime().asc()).list();
        ArrayList<String> activties = new ArrayList<String>();
        ArrayList<String> flows = new ArrayList<String>();
        for (HistoricActivityInstance activityInstance : activityInstances) {
            if ("sequenceFlow".equals(activityInstance.getActivityType())) {
                flows.add(activityInstance.getActivityId());
                continue;
            }
            activties.add(activityInstance.getActivityId());
        }
        try {
            Model modelData = this.repositoryService.getModel(procDefId);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            byte[] modelEditorSource = this.repositoryService.getModelEditorSource(modelData.getId());
            JsonNode editorNode = new ObjectMapper().readTree(modelEditorSource);
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
            DefaultProcessDiagramGenerator diagramGenerator = new DefaultProcessDiagramGenerator();
            InputStream inputStream = diagramGenerator.generateDiagram(bpmnModel, "png", activties, flows, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0, false);
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.setHeader("Content-Disposition", "attachment; filename=" + bpmnModel.getMainProcess().getId() + ".png");
            response.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

