/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common;

import com.jeeplus.common.TokenProvider;
import com.jeeplus.common.redis.RedisUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthenticationEntryPoint
implements AuthenticationEntryPoint,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationEntryPoint.class);
    private static final long serialVersionUID = -8970718410437077606L;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String errMsg;
        String token = TokenProvider.resolveToken(request);
        if (StringUtils.isEmpty((CharSequence)token)) {
            errMsg = "\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c!";
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        } else {
            Object accessTokenObj = RedisUtils.getInstance().get("user:cache:token", token);
            if (accessTokenObj != null && accessTokenObj.toString().equals("kickOut")) {
                RedisUtils.getInstance().delete("user:cache:token", token);
                RedisUtils.getInstance().delete("user:cache:online:users", token);
                errMsg = "\u60a8\u7684\u8d26\u53f7\u5728\u53e6\u4e00\u53f0\u8bbe\u5907\u4e0a\u767b\u5f55,\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u7acb\u5373\u4fee\u6539\u5bc6\u7801\uff01";
            } else {
                errMsg = "\u60a8\u7684\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01";
            }
            response.setStatus(HttpStatus.REQUEST_TIMEOUT.value());
        }
        log.error(errMsg);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter printWriter = response.getWriter();
        printWriter.write(errMsg);
        printWriter.flush();
    }
}

