/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.common.handler;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.extension.domain.TaskDefExtension;
import com.jeeplus.extension.service.TaskDefExtensionService;
import com.jeeplus.extension.service.dto.FlowAssigneeDTO;
import com.jeeplus.flowable.common.handler.CollectionUtils;
import com.jeeplus.flowable.utils.FlowableUtils;
import com.jeeplus.sys.feign.IUserApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class ExtUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final Logger log = LoggerFactory.getLogger(ExtUserTaskActivityBehavior.class);
    private static final long serialVersionUID = 7711531472879418236L;

    public ExtUserTaskActivityBehavior(UserTask userTask) {
        super(userTask);
    }

    protected void handleAssignments(TaskService taskService, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList candidateIds;
        Process process = ((RepositoryService)SpringUtil.getBean(RepositoryService.class)).getBpmnModel(task.getProcessDefinitionId()).getMainProcess();
        FlowElement flowElement = process.getFlowElement(task.getTaskDefinitionKey());
        Boolean isMultiInstance = FlowableUtils.isFlowElementMultiInstance((FlowElement)flowElement);
        if (isMultiInstance.booleanValue()) {
            super.handleAssignments(taskService, assignee, owner, candidateUsers, candidateGroups, task, expressionManager, execution, processEngineConfiguration);
            return;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((TaskDefExtensionService)SpringUtil.getBean(TaskDefExtensionService.class)).lambdaQuery().eq(TaskDefExtension::getProcessDefId, (Object)process.getId())).eq(TaskDefExtension::getTaskDefId, (Object)task.getTaskDefinitionKey())).list();
        LinkedHashSet<String> candidateUserIds = new LinkedHashSet<String>();
        if (list.size() > 0) {
            TaskDefExtension taskDefExtension = (TaskDefExtension)list.get(0);
            List assigneeList = ((TaskDefExtensionService)SpringUtil.getBean(TaskDefExtensionService.class)).getById(taskDefExtension.getId()).getFlowAssigneeList();
            IUserApi userApi = (IUserApi)SpringUtil.getBean(IUserApi.class);
            block23: for (FlowAssigneeDTO flowAssignee : assigneeList) {
                switch (flowAssignee.getType()) {
                    case "user": {
                        candidateUserIds.addAll(Arrays.asList(flowAssignee.getValue().split(",")));
                        break;
                    }
                    case "post": {
                        if (!StrUtil.isNotBlank((CharSequence)flowAssignee.getValue())) break;
                        String postId = flowAssignee.getValue();
                        String[] userList = userApi.findListByPostId(postId);
                        candidateUserIds.addAll(CollectionUtils.extractToList((Collection)userList, (String)"id"));
                        break;
                    }
                    case "company": {
                        if (!StrUtil.isNotBlank((CharSequence)flowAssignee.getValue())) break;
                        String companyId = flowAssignee.getValue();
                        String[] userList = userApi.findListByCompanyId(companyId);
                        candidateUserIds.addAll(CollectionUtils.extractToList((Collection)userList, (String)"id"));
                        break;
                    }
                    case "depart": {
                        if (!StrUtil.isNotBlank((CharSequence)flowAssignee.getValue())) break;
                        String officeId = flowAssignee.getValue();
                        String[] userList = userApi.findListByOfficeId(officeId);
                        candidateUserIds.addAll(CollectionUtils.extractToList((Collection)userList, (String)"id"));
                        break;
                    }
                    case "role": {
                        String[] roleIds;
                        if (!StrUtil.isNotBlank((CharSequence)flowAssignee.getValue())) break;
                        for (String roleId : roleIds = flowAssignee.getValue().split(",")) {
                            List userList = userApi.findListByRoleId(roleId);
                            candidateUserIds.addAll(CollectionUtils.extractToList((Collection)userList, (String)"id"));
                        }
                        continue block23;
                    }
                    case "applyUserId": {
                        candidateUserIds.add("${applyUserId}");
                        break;
                    }
                    case "previousExecutor": {
                        HistoricTaskInstance lastHisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoryService)SpringUtil.getBean(HistoryService.class)).createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).finished().includeProcessVariables()).orderByHistoricTaskInstanceEndTime().desc()).list().get(0);
                        candidateUserIds.add(lastHisTask.getAssignee());
                        break;
                    }
                    case "currentUserId": {
                        candidateUserIds.add(userApi.getByToken(TokenProvider.getCurrentToken()).getId());
                        break;
                    }
                    case "sql": {
                        Map userMap = ((JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class)).queryForMap(flowAssignee.getValue());
                        candidateUserIds.add(userMap.get("id").toString());
                        break;
                    }
                }
            }
        }
        if ((candidateIds = new ArrayList(candidateUserIds)).size() == 0) {
            super.handleAssignments(taskService, null, owner, (List)Lists.newArrayList(), (List)Lists.newArrayList(), task, expressionManager, execution, processEngineConfiguration);
        } else if (candidateIds.size() == 1) {
            super.handleAssignments(taskService, (String)candidateIds.get(0), owner, (List)Lists.newArrayList(), (List)Lists.newArrayList(), task, expressionManager, execution, processEngineConfiguration);
        } else if (candidateIds.size() > 1) {
            super.handleAssignments(taskService, null, owner, candidateIds, null, task, expressionManager, execution, processEngineConfiguration);
        }
    }
}

