/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FileProperties {
    @Value(value="${file.allowedType}")
    private String fileType;
    @Value(value="${file.extensions.file}")
    private String fileExtensions;
    @Value(value="${file.extensions.image}")
    private String imageExtensions;
    @Value(value="${file.extensions.video}")
    private String videoExtensions;
    @Value(value="${file.extensions.audio}")
    private String audioExtensions;
    @Value(value="${file.extensions.office}")
    private String officeExtensions;

    public boolean isAvailable(String fileName) {
        switch (this.fileType) {
            case "all": {
                return true;
            }
            case "file": {
                return this.isContain(this.fileExtensions, fileName);
            }
            case "image": {
                return this.isContain(this.imageExtensions, fileName);
            }
            case "video": {
                return this.isContain(this.videoExtensions, fileName);
            }
            case "audio": {
                return this.isContain(this.audioExtensions, fileName);
            }
            case "office": {
                return this.isContain(this.officeExtensions, fileName);
            }
        }
        return false;
    }

    public boolean isImage(String fileName) {
        return this.isContain(this.imageExtensions, fileName);
    }

    public boolean isContain(String extensions, String fileName) {
        String[] extensionArray = extensions.split(",");
        String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String extension : extensionArray) {
            if (!extension.trim().equals(fileExtension)) continue;
            return true;
        }
        return false;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getFileExtensions() {
        return this.fileExtensions;
    }

    public String getImageExtensions() {
        return this.imageExtensions;
    }

    public String getVideoExtensions() {
        return this.videoExtensions;
    }

    public String getAudioExtensions() {
        return this.audioExtensions;
    }

    public String getOfficeExtensions() {
        return this.officeExtensions;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setImageExtensions(String imageExtensions) {
        this.imageExtensions = imageExtensions;
    }

    public void setVideoExtensions(String videoExtensions) {
        this.videoExtensions = videoExtensions;
    }

    public void setAudioExtensions(String audioExtensions) {
        this.audioExtensions = audioExtensions;
    }

    public void setOfficeExtensions(String officeExtensions) {
        this.officeExtensions = officeExtensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileProperties)) {
            return false;
        }
        FileProperties other = (FileProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$fileExtensions = this.getFileExtensions();
        String other$fileExtensions = other.getFileExtensions();
        if (this$fileExtensions == null ? other$fileExtensions != null : !this$fileExtensions.equals(other$fileExtensions)) {
            return false;
        }
        String this$imageExtensions = this.getImageExtensions();
        String other$imageExtensions = other.getImageExtensions();
        if (this$imageExtensions == null ? other$imageExtensions != null : !this$imageExtensions.equals(other$imageExtensions)) {
            return false;
        }
        String this$videoExtensions = this.getVideoExtensions();
        String other$videoExtensions = other.getVideoExtensions();
        if (this$videoExtensions == null ? other$videoExtensions != null : !this$videoExtensions.equals(other$videoExtensions)) {
            return false;
        }
        String this$audioExtensions = this.getAudioExtensions();
        String other$audioExtensions = other.getAudioExtensions();
        if (this$audioExtensions == null ? other$audioExtensions != null : !this$audioExtensions.equals(other$audioExtensions)) {
            return false;
        }
        String this$officeExtensions = this.getOfficeExtensions();
        String other$officeExtensions = other.getOfficeExtensions();
        return !(this$officeExtensions == null ? other$officeExtensions != null : !this$officeExtensions.equals(other$officeExtensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $fileExtensions = this.getFileExtensions();
        result = result * 59 + ($fileExtensions == null ? 43 : $fileExtensions.hashCode());
        String $imageExtensions = this.getImageExtensions();
        result = result * 59 + ($imageExtensions == null ? 43 : $imageExtensions.hashCode());
        String $videoExtensions = this.getVideoExtensions();
        result = result * 59 + ($videoExtensions == null ? 43 : $videoExtensions.hashCode());
        String $audioExtensions = this.getAudioExtensions();
        result = result * 59 + ($audioExtensions == null ? 43 : $audioExtensions.hashCode());
        String $officeExtensions = this.getOfficeExtensions();
        result = result * 59 + ($officeExtensions == null ? 43 : $officeExtensions.hashCode());
        return result;
    }

    public String toString() {
        return "FileProperties(fileType=" + this.getFileType() + ", fileExtensions=" + this.getFileExtensions() + ", imageExtensions=" + this.getImageExtensions() + ", videoExtensions=" + this.getVideoExtensions() + ", audioExtensions=" + this.getAudioExtensions() + ", officeExtensions=" + this.getOfficeExtensions() + ")";
    }
}

