/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common;

import com.jeeplus.common.CustomUserDetailsService;
import com.jeeplus.common.JWTConfigurer;
import com.jeeplus.common.JwtAccessDeniedHandler;
import com.jeeplus.common.JwtAuthenticationEntryPoint;
import com.jeeplus.common.TokenProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Order(value=0)
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private CustomUserDetailsService userDatailService;
    @Autowired
    private JwtAuthenticationEntryPoint unauthorizedHandler;
    @Autowired
    private JwtAccessDeniedHandler accessDeniedHandler;
    @Autowired
    private TokenProvider tokenProvider;

    protected void configure(AuthenticationManagerBuilder auth) {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setHideUserNotFoundExceptions(true);
        provider.setUserDetailsService(this.userDetailsService());
        provider.setPasswordEncoder((PasswordEncoder)this.passwordEncoder());
        provider.setUserDetailsService((UserDetailsService)this.userDatailService);
        auth.authenticationProvider((AuthenticationProvider)provider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.headers().frameOptions().disable().and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler).and()).csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().anyRequest()).authenticated().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/doc.html", "/swagger-ui.html", "/userfiles/**", "/static/**", "/swagger**/**", "/webjars/**"});
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    private JWTConfigurer securityConfigurerAdapter() throws Exception {
        return new JWTConfigurer(this.tokenProvider, this.authenticationManager());
    }

    @Bean
    public AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }
}

