/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common;

import cn.hutool.extra.spring.SpringUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jeeplus.common.utils.RequestUtils;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.sys.feign.IUserApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    public static final String TOKEN = "token";
    public static final String SIGN_CODE = "@#&#$^JWE@#$F123";

    public static boolean validateToken(String token) {
        try {
            String userName = TokenProvider.getLoginName(token);
            Algorithm algorithm = Algorithm.HMAC256((String)SIGN_CODE);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", userName).build();
            verifier.verify(token);
            return true;
        }
        catch (TokenExpiredException e) {
            log.error("\u60a8\u7684\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef\uff01");
        }
        return false;
    }

    public static String getLoginName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createAccessToken(String username) {
        Date date = new Date(System.currentTimeMillis() + JeePlusProperties.newInstance().getEXPIRE_TIME());
        Algorithm algorithm = Algorithm.HMAC256((String)SIGN_CODE);
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static Authentication getAuthentication(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        String username = jwt.getClaim("username").asString();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        String userName = TokenProvider.getLoginName(token);
        Set permissions = ((IUserApi)SpringUtil.getBean(IUserApi.class)).getPermissions(userName);
        for (String permission : permissions) {
            authorities.add(new SimpleGrantedAuthority(permission));
        }
        User principal = new User(username, "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public static String resolveToken(HttpServletRequest httpServletRequest) {
        return RequestUtils.resolveToken((HttpServletRequest)httpServletRequest, (String)TOKEN);
    }

    public static String getCurrentToken() {
        return TokenProvider.resolveToken(RequestUtils.getRequest());
    }
}

