/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.common;

import cn.hutool.core.util.StrUtil;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.common.redis.RedisUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JWTFilter
extends GenericFilterBean {
    private final TokenProvider tokenProvider;

    public JWTFilter(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean isLogin;
        Object accessTokenObj;
        String loginName;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String token = TokenProvider.resolveToken(request);
        String accessToken = null;
        if (StrUtil.isNotEmpty((CharSequence)token) && StrUtil.isNotEmpty((CharSequence)(loginName = TokenProvider.getLoginName(token))) && (accessTokenObj = RedisUtils.getInstance().get("user:cache:token", token)) != null) {
            accessToken = accessTokenObj.toString();
        }
        boolean bl = isLogin = StrUtil.isNotBlank(accessToken) && !accessToken.equals("kickOut");
        if (isLogin) {
            if (TokenProvider.validateToken(accessToken) && SecurityContextHolder.getContext().getAuthentication() == null) {
                Authentication authentication = TokenProvider.getAuthentication(accessToken);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

