/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel.converter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Lists;
import com.jeeplus.sys.feign.IRoleApi;
import com.jeeplus.sys.service.dto.RoleDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExcelRoleListDTOConverter
implements Converter<List<RoleDTO>> {
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public List<RoleDTO> convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        ArrayList roleList = Lists.newArrayList();
        String val = cellData.getStringValue();
        for (String roleName : StrUtil.split((CharSequence)val, (CharSequence)",")) {
            RoleDTO roleDTO = ((IRoleApi)SpringUtil.getBean(IRoleApi.class)).getRoleDTOByName(roleName);
            roleList.add(roleDTO);
        }
        return roleList.size() > 0 ? roleList : null;
    }

    public WriteCellData<?> convertToExcelData(List<RoleDTO> roleDTOList, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        List roleNames = roleDTOList.stream().map(roleDTO -> roleDTO.getName()).collect(Collectors.toList());
        return new WriteCellData(StrUtil.join((CharSequence)",", roleNames));
    }
}

