/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel.converter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Lists;
import com.jeeplus.sys.feign.IPostApi;
import com.jeeplus.sys.service.dto.PostDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExcelPostListDTOConverter
implements Converter<List<PostDTO>> {
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public List<PostDTO> convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        ArrayList postList = Lists.newArrayList();
        String val = cellData.getStringValue();
        for (String postName : StrUtil.split((CharSequence)val, (CharSequence)",")) {
            PostDTO postDTO = ((IPostApi)SpringUtil.getBean(IPostApi.class)).getPostDTOByName(postName);
            postList.add(postDTO);
        }
        return postList.size() > 0 ? postList : null;
    }

    public WriteCellData<?> convertToExcelData(List<PostDTO> postDTOList, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        List postNames = postDTOList.stream().map(postDTO -> postDTO.getName()).collect(Collectors.toList());
        return new WriteCellData(StrUtil.join((CharSequence)",", postNames));
    }
}

