/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.excepiton;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.gateway.security.TokenProvider;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class JwtAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationEntryPoint.class);
    @Autowired
    private ObjectMapper mapper;

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException e) {
        String errMsg;
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.FORBIDDEN);
        String token = TokenProvider.resolveToken((ServerHttpRequest)exchange.getRequest());
        if (StrUtil.isEmpty((CharSequence)token)) {
            errMsg = "\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c!";
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
        } else {
            Object accessTokenObj = RedisUtils.getInstance().get("user:cache:token", token);
            if (accessTokenObj != null && accessTokenObj.toString().equals("kickOut")) {
                RedisUtils.getInstance().delete("user:cache:token", token);
                RedisUtils.getInstance().delete("user:cache:online:users", token);
                errMsg = "\u60a8\u7684\u8d26\u53f7\u5728\u53e6\u4e00\u53f0\u8bbe\u5907\u4e0a\u767b\u5f55,\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u7acb\u5373\u4fee\u6539\u5bc6\u7801\uff01";
            } else {
                errMsg = "\u60a8\u7684\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01";
            }
            response.setStatusCode(HttpStatus.REQUEST_TIMEOUT);
        }
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
        log.error(errMsg);
        try {
            DataBuffer buffer = response.bufferFactory().wrap(this.mapper.writeValueAsBytes((Object)errMsg));
            return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError(error -> DataBufferUtils.release((DataBuffer)buffer));
        }
        catch (JsonProcessingException var5) {
            return Mono.error((Throwable)var5);
        }
    }
}

