/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTriggerPoolHelper {
    private static Logger logger = LoggerFactory.getLogger(JobTriggerPoolHelper.class);
    private ThreadPoolExecutor fastTriggerPool = null;
    private ThreadPoolExecutor slowTriggerPool = null;
    private volatile long minTim = System.currentTimeMillis() / 60000L;
    private volatile ConcurrentMap<Integer, AtomicInteger> jobTimeoutCountMap = new ConcurrentHashMap();
    private static JobTriggerPoolHelper helper = new JobTriggerPoolHelper();

    public void start() {
        this.fastTriggerPool = new ThreadPoolExecutor(10, XxlJobAdminConfig.getAdminConfig().getTriggerPoolFastMax(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        this.slowTriggerPool = new ThreadPoolExecutor(10, XxlJobAdminConfig.getAdminConfig().getTriggerPoolSlowMax(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void stop() {
        this.fastTriggerPool.shutdownNow();
        this.slowTriggerPool.shutdownNow();
        logger.info(">>>>>>>>> xxl-job trigger thread pool shutdown success.");
    }

    public void addTrigger(int jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorShardingParam, String executorParam, String addressList) {
        ThreadPoolExecutor triggerPool_ = this.fastTriggerPool;
        AtomicInteger jobTimeoutCount = (AtomicInteger)this.jobTimeoutCountMap.get(jobId);
        if (jobTimeoutCount != null && jobTimeoutCount.get() > 10) {
            triggerPool_ = this.slowTriggerPool;
        }
        triggerPool_.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void toStart() {
        helper.start();
    }

    public static void toStop() {
        helper.stop();
    }

    public static void trigger(int jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorShardingParam, String executorParam, String addressList) {
        helper.addTrigger(jobId, triggerType, failRetryCount, executorShardingParam, executorParam, addressList);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ long access$100(JobTriggerPoolHelper x0) {
        return x0.minTim;
    }

    static /* synthetic */ long access$102(JobTriggerPoolHelper x0, long x1) {
        x0.minTim = x1;
        return x0.minTim;
    }

    static /* synthetic */ ConcurrentMap access$200(JobTriggerPoolHelper x0) {
        return x0.jobTimeoutCountMap;
    }
}

