/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.note.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.google.common.collect.Lists;
import com.jeeplus.common.excel.EasyExcelUtils;
import com.jeeplus.common.excel.ExcelOptions;
import com.jeeplus.core.mapstruct.EntityWrapper;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.logging.annotation.ApiLog;
import com.jeeplus.test.note.domain.TestNote;
import com.jeeplus.test.note.service.TestNoteService;
import com.jeeplus.test.note.service.dto.TestNoteDTO;
import com.jeeplus.test.note.service.mapstruct.TestNoteWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5bcc\u6587\u672c"})
@RestController
@RequestMapping(value={"/test/note/testNote"})
public class TestNoteController {
    @Autowired
    private TestNoteService testNoteService;
    @Autowired
    private TestNoteWrapper testNoteWrapper;

    @ApiLog(value="\u67e5\u8be2\u5bcc\u6587\u672c\u5217\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u5bcc\u6587\u672c\u5217\u8868\u6570\u636e")
    @PreAuthorize(value="hasAuthority('test:note:testNote:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<TestNoteDTO>> list(TestNoteDTO testNoteDTO, Page<TestNote> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)testNoteDTO, TestNoteDTO.class);
        Page result = this.testNoteWrapper.toDTO((Page)this.testNoteService.page(page, (Wrapper)queryWrapper));
        return ResponseEntity.ok((Object)result);
    }

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u5bcc\u6587\u672c\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u5bcc\u6587\u672c\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:note:testNote:view','test:note:testNote:add','test:note:testNote:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<TestNoteDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.testNoteWrapper.toDTO(this.testNoteService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u5bcc\u6587\u672c")
    @ApiOperation(value="\u4fdd\u5b58\u5bcc\u6587\u672c")
    @PreAuthorize(value="hasAnyAuthority('test:note:testNote:add','test:note:testNote:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<String> save(@Valid @RequestBody TestNoteDTO testNoteDTO) {
        this.testNoteService.saveOrUpdate(this.testNoteWrapper.toEntity((Object)testNoteDTO));
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5bcc\u6587\u672c\u6210\u529f");
    }

    @ApiLog(value="\u5220\u9664\u5bcc\u6587\u672c")
    @ApiOperation(value="\u5220\u9664\u5bcc\u6587\u672c")
    @PreAuthorize(value="hasAuthority('test:note:testNote:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.testNoteService.removeByIds((Collection)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5bcc\u6587\u672c\u6210\u529f");
    }

    @ApiLog(value="\u5bfc\u51fa\u5bcc\u6587\u672c\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:note:testNote:export')")
    @GetMapping(value={"export"})
    public void exportFile(TestNoteDTO testNoteDTO, Page<TestNote> page, ExcelOptions options, HttpServletResponse response) throws Exception {
        String fileName = options.getFilename();
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)testNoteDTO, TestNoteDTO.class);
        if (!"current".equals(options.getMode())) {
            if ("selected".equals(options.getMode())) {
                queryWrapper.in((Object)"id", (Collection)options.getSelectIds());
            } else {
                page.setSize(-1L);
                page.setCurrent(0L);
            }
        }
        List result = ((Page)this.testNoteService.page(page, (Wrapper)queryWrapper)).getRecords();
        EasyExcelUtils.newInstance((IService)this.testNoteService, (EntityWrapper)this.testNoteWrapper).exportExcel(result, options.getSheetName(), TestNoteDTO.class, fileName, (Collection)options.getExportFields(), response);
    }

    @PreAuthorize(value="hasAnyAuthority('test:note:testNote:import')")
    @PostMapping(value={"import"})
    public ResponseEntity importFile(MultipartFile file) throws IOException {
        String result = EasyExcelUtils.newInstance((IService)this.testNoteService, (EntityWrapper)this.testNoteWrapper).importExcel(file, TestNoteDTO.class);
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('test:note:testNote:import')")
    @GetMapping(value={"import/template"})
    public void importFileTemplate(HttpServletResponse response) throws IOException {
        String fileName = "\u5bcc\u6587\u672c\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
        ArrayList list = Lists.newArrayList();
        EasyExcelUtils.newInstance((IService)this.testNoteService, (EntityWrapper)this.testNoteWrapper).exportExcel((List)list, "\u5bcc\u6587\u672c\u6570\u636e", TestNoteDTO.class, fileName, null, response);
    }
}

