/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service.converter.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jeeplus.flowable.service.converter.json.FlowBpmnJsonConverter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.util.XmlUtil;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.service.ModelServiceImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="flowModelService")
public class FlowModelService
extends ModelServiceImpl {
    protected FlowBpmnJsonConverter bpmnJsonConverter = new FlowBpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();

    public byte[] getBpmnXML(BpmnModel bpmnModel) {
        for (Process process : bpmnModel.getProcesses()) {
            char firstCharacter;
            if (!StringUtils.isNotEmpty((CharSequence)process.getId()) || !Character.isDigit(firstCharacter = process.getId().charAt(0))) continue;
            process.setId("a" + process.getId());
        }
        byte[] xmlBytes = this.bpmnXMLConverter.convertToXML(bpmnModel);
        return xmlBytes;
    }

    public ModelRepresentation importNewVersion(String modelId, String fileName, InputStream modelStream) {
        Model processModel = this.getModel(modelId);
        if (fileName != null && (fileName.endsWith(".bpmn") || fileName.endsWith(".bpmn20.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(modelStream, "UTF-8");
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                BpmnModel bpmnModel = this.bpmnXMLConverter.convertToBpmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                    throw new BadRequestException("No process found in definition " + fileName);
                }
                if (bpmnModel.getLocationMap().size() == 0) {
                    throw new BadRequestException("No required BPMN DI information found in definition " + fileName);
                }
                ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
                Model savedModel = this.saveModel(modelId, processModel.getName(), processModel.getKey(), processModel.getDescription(), modelNode.toString(), true, "Version import via REST service", SecurityUtils.getCurrentUserId());
                return new ModelRepresentation((AbstractModel)savedModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .bpmn and .bpmn20.xml files are supported not " + fileName);
    }
}

