/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.controller;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.extension.domain.FlowCopy;
import com.jeeplus.extension.service.FlowCopyService;
import com.jeeplus.flowable.service.FlowProcessService;
import com.jeeplus.flowable.vo.ProcessStatus;
import com.jeeplus.flowable.vo.ProcessVo;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowable/process"})
public class FlowableProcessController {
    @Autowired
    private FlowProcessService flowProcessService;
    @Autowired
    private FlowCopyService flowCopyService;

    @GetMapping(value={"list"})
    public ResponseEntity processListData(Page<Map> page, String category) {
        page = this.flowProcessService.processList(page, category);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"exist"})
    public ResponseEntity exist(String key) {
        ProcessDefinition processDefinition = this.flowProcessService.getProcessDefinitionByKey(key);
        if (processDefinition == null) {
            return ResponseEntity.ok((Object)false);
        }
        return ResponseEntity.ok((Object)true);
    }

    @GetMapping(value={"runningData"})
    public ResponseEntity runningListData(Page<ProcessInstance> page, String title, String procInsId, String procDefKey) throws Exception {
        Page result = this.flowProcessService.runningList(page, title, procInsId, procDefKey);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"historyListData"})
    public ResponseEntity historyListData(Page<ProcessVo> page, String title, String procInsId, String procDefKey) throws Exception {
        page = this.flowProcessService.historyList(page, title, procInsId, procDefKey);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"resource/read"})
    public void resourceRead(String procDefId, String proInsId, String resType, HttpServletResponse response) throws Exception {
        InputStream resourceAsStream = this.flowProcessService.resourceRead(procDefId, proInsId, resType);
        byte[] b = new byte[1024];
        int len = -1;
        if ("xml".equals(resType)) {
            response.reset();
            response.setContentType("application/octet-stream; charset=utf-8");
            String fileName = this.flowProcessService.getProcessDefinition(procDefId).getResourceName();
            response.setHeader("Content-Disposition", URLEncoder.encode(fileName, "UTF8"));
        }
        while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @GetMapping(value={"getFlowChart"})
    public Map getFlowChart(String processDefId) {
        return this.flowProcessService.getImageStream(processDefId);
    }

    @PutMapping(value={"update/{state}"})
    public ResponseEntity updateState(@PathVariable(value="state") String state, String procDefId) {
        String message = this.flowProcessService.updateState(state, procDefId);
        return ResponseEntity.ok((Object)message);
    }

    @PostMapping(value={"convert/toModel"})
    public ResponseEntity convertToModel(String procDefId) throws UnsupportedEncodingException, XMLStreamException {
        Model modelData = this.flowProcessService.convertToModel(procDefId);
        return ResponseEntity.ok((Object)("\u8f6c\u6362\u6a21\u578b\u6210\u529f\uff0c\u6a21\u578bID=" + modelData.getId()));
    }

    @DemoMode
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String deploymentIds) {
        String[] idArray;
        for (String id : idArray = deploymentIds.split(",")) {
            this.flowProcessService.deleteDeployment(id);
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"deleteProcIns"})
    public ResponseEntity deleteProcIns(String ids, String reason) {
        try {
            for (String id : ids.split(",")) {
                this.flowProcessService.deleteProcIns(id, reason);
            }
            return ResponseEntity.ok((Object)"\u6d41\u7a0b\u5b9e\u4f8b\u5220\u9664\u6210\u529f!");
        }
        catch (FlowableObjectNotFoundException e) {
            return ResponseEntity.ok((Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f!");
        }
    }

    @RequestMapping(value={"revokeProcIns"})
    public ResponseEntity revokeProcIns(String id) {
        try {
            this.flowProcessService.callBackProcessInstanceById(id);
            return ResponseEntity.ok((Object)"\u6d41\u7a0b\u64a4\u9500\u6210\u529f!");
        }
        catch (FlowableObjectNotFoundException e) {
            return ResponseEntity.ok((Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f!");
        }
    }

    @RequestMapping(value={"stop"})
    public ResponseEntity stopProcIns(String id, String message) {
        try {
            this.flowProcessService.stopProcessInstanceById(id, ProcessStatus.STOP, message);
            return ResponseEntity.ok((Object)"\u7ec8\u6b62\u6d41\u7a0b\u6210\u529f!");
        }
        catch (FlowableObjectNotFoundException e) {
            return ResponseEntity.ok((Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f!");
        }
    }

    @GetMapping(value={"queryProcessStatus"})
    public ResponseEntity queryProcessStatus(String procDefId, String procInsId) throws Exception {
        ProcessVo processVo = this.flowProcessService.queryProcessState(procDefId, procInsId);
        return ResponseEntity.ok((Object)processVo.getCode());
    }

    @DeleteMapping(value={"deleteAllProcIns"})
    public ResponseEntity deleteAllProcIns(String procInsIds) {
        String[] procInsIdArra;
        for (String procInsId : procInsIdArra = procInsIds.split(",")) {
            this.flowProcessService.delHistoryProcInsById(procInsId);
            ((LambdaUpdateChainWrapper)this.flowCopyService.lambdaUpdate().eq(FlowCopy::getProcInsId, (Object)procInsId)).remove();
        }
        return ResponseEntity.ok((Object)("\u5220\u9664\u6210\u529f\uff0c\u6d41\u7a0b\u5b9e\u4f8bID=" + procInsIds));
    }
}

