/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jeeplus.aop.demo.annotation.DemoMode;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.flowable.model.FlowModel;
import com.jeeplus.flowable.service.FlowableModelService;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.ConflictingRequestException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.ModelKeyRepresentation;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.rest.app.ModelBpmnResource;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowable/model"})
public class FlowableModelController {
    @Autowired
    private FlowableModelService flowableModelService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ModelBpmnResource modelBpmnResource;
    @Autowired
    private IUserApi userApi;

    @GetMapping(value={"account"}, produces={"application/json"})
    public UserRepresentation account() {
        UserDTO user = this.userApi.getByToken(TokenProvider.getCurrentToken());
        UserEntityImpl fUser = new UserEntityImpl();
        fUser.setId(user.getId());
        fUser.setFirstName(user.getName());
        fUser.setLastName("");
        fUser.setEmail(user.getEmail());
        UserRepresentation userRepresentation = new UserRepresentation((User)fUser);
        return userRepresentation;
    }

    @GetMapping(value={"list"})
    public ResponseEntity data(Page<FlowModel> page, String filter, HttpServletRequest request) {
        page = this.flowableModelService.getModels(page, filter, "modifiedDesc", Integer.valueOf(0), request);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"getBpmnXml"})
    public String getBpmnXml(String id, HttpServletResponse response) {
        return this.flowableModelService.export(id, response);
    }

    @GetMapping(value={"exportBpmnXml"})
    public void exportBpmnXml(String id, HttpServletResponse response) throws Exception {
        this.modelBpmnResource.getProcessModelBpmn20Xml(response, id);
    }

    @PutMapping(value={"updateCategory"})
    public ResponseEntity updateCategory(String id, String category) {
        this.repositoryService.setProcessDefinitionCategory(id, category);
        return ResponseEntity.ok((Object)("\u8bbe\u7f6e\u6210\u529f\uff0c\u6a21\u5757ID=" + id));
    }

    @DemoMode
    @DeleteMapping(value={"delete"})
    public ResponseEntity deleteAll(String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.flowableModelService.delete(id);
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"copy"})
    public ResponseEntity copy(String id) throws Exception {
        Model sourceModel = this.modelService.getModel(id);
        ModelRepresentation modelRepresentation = new ModelRepresentation();
        modelRepresentation.setKey("Process_" + UUID.randomUUID());
        modelRepresentation.setName(sourceModel.getName() + "_copy");
        modelRepresentation.setModelType(Integer.valueOf(0));
        modelRepresentation.setDescription("");
        modelRepresentation.setKey(modelRepresentation.getKey().replaceAll(" ", ""));
        this.checkForDuplicateKey(modelRepresentation);
        String json = this.modelService.createModelJson(modelRepresentation);
        UserDTO user = this.userApi.getByToken(TokenProvider.getCurrentToken());
        Model newModel = this.modelService.createModel(modelRepresentation, json, user.getId());
        String modelId = newModel.getId();
        ObjectNode sourceObjectNode = (ObjectNode)this.objectMapper.readTree(sourceModel.getModelEditorJson());
        ObjectNode editorNode = sourceObjectNode.deepCopy();
        ObjectNode properties = this.objectMapper.createObjectNode();
        properties.put("process_id", newModel.getKey());
        properties.put("name", newModel.getName());
        editorNode.set("properties", (JsonNode)properties);
        newModel.setModelEditorJson(editorNode.toString());
        this.modelService.saveModel(modelId, newModel.getName(), newModel.getKey(), newModel.getDescription(), newModel.getModelEditorJson(), true, "", user.getId());
        return ResponseEntity.ok((Object)"\u62f7\u8d1d\u6210\u529f!");
    }

    @PutMapping(value={"deploy"})
    public ResponseEntity deploy(String id, String category, String tenantId) {
        String result = this.flowableModelService.deploy(id, category, tenantId);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/rest/models"}, produces={"application/json"})
    public ModelRepresentation createModel(@RequestBody ModelRepresentation modelRepresentation) {
        modelRepresentation.setKey(modelRepresentation.getKey().replaceAll(" ", ""));
        this.checkForDuplicateKey(modelRepresentation);
        String json = this.modelService.createModelJson(modelRepresentation);
        Model newModel = this.modelService.createModel(modelRepresentation, json, SecurityUtils.getCurrentUserId());
        return new ModelRepresentation((AbstractModel)newModel);
    }

    @PostMapping(value={"saveModel/{modelId}"})
    public ModelRepresentation saveModel(@PathVariable String modelId, @RequestBody MultiValueMap<String, String> values) {
        long lastUpdated = -1L;
        String lastUpdatedString = (String)values.getFirst((Object)"lastUpdated");
        if (lastUpdatedString == null) {
            throw new BadRequestException("Missing lastUpdated date");
        }
        lastUpdated = DateUtil.parse((CharSequence)lastUpdatedString).getTime();
        Model model = this.modelService.getModel(modelId);
        boolean currentUserIsOwner = model.getLastUpdatedBy().equals(this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
        String resolveAction = (String)values.getFirst((Object)"conflictResolveAction");
        if (model.getLastUpdated().getTime() / 1000L != lastUpdated / 1000L) {
            if ("saveAs".equals(resolveAction)) {
                String isNewVersionString = (String)values.getFirst((Object)"saveAs");
                String json = (String)values.getFirst((Object)"json_xml");
                json = this.flowableModelService.changeXmlToJson(json);
                return this.createNewModel(isNewVersionString, model.getDescription(), model.getModelType(), json);
            }
            if ("overwrite".equals(resolveAction)) {
                return this.updateModel(model, values, false);
            }
            if ("newVersion".equals(resolveAction)) {
                return this.updateModel(model, values, true);
            }
            String isNewVersionString = (String)values.getFirst((Object)"newversion");
            if (currentUserIsOwner && "true".equals(isNewVersionString)) {
                return this.updateModel(model, values, true);
            }
            ConflictingRequestException exception = new ConflictingRequestException("Process model was updated in the meantime");
            exception.addCustomData("userFullName", (Object)model.getLastUpdatedBy());
            exception.addCustomData("newVersionAllowed", (Object)currentUserIsOwner);
            throw exception;
        }
        return this.updateModel(model, values, false);
    }

    protected ModelRepresentation updateModel(Model model, MultiValueMap<String, String> values, boolean forceNewVersion) {
        String name = (String)values.getFirst((Object)"name");
        String key = ((String)values.getFirst((Object)"key")).replaceAll(" ", "");
        String description = (String)values.getFirst((Object)"description");
        String isNewVersionString = (String)values.getFirst((Object)"newversion");
        String newVersionComment = null;
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(model, model.getModelType(), key);
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Model with provided key already exists " + key);
        }
        boolean newVersion = false;
        if (forceNewVersion) {
            newVersion = true;
            newVersionComment = (String)values.getFirst((Object)"comment");
        } else if (isNewVersionString != null) {
            newVersion = "true".equals(isNewVersionString);
            newVersionComment = (String)values.getFirst((Object)"comment");
        }
        String json = (String)values.getFirst((Object)"json_xml");
        json = this.flowableModelService.changeXmlToJson(json);
        try {
            ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(json);
            ObjectNode propertiesNode = (ObjectNode)editorJsonNode.get("properties");
            propertiesNode.put("process_id", key);
            propertiesNode.put("name", name);
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                propertiesNode.put("documentation", description);
            }
            editorJsonNode.set("properties", (JsonNode)propertiesNode);
            model = this.modelService.saveModel(model.getId(), name, key, description, editorJsonNode.toString(), newVersion, newVersionComment, SecurityUtils.getCurrentUserId());
            return new ModelRepresentation((AbstractModel)model);
        }
        catch (Exception var15) {
            throw new BadRequestException("Process model could not be saved " + model.getId());
        }
    }

    protected void checkForDuplicateKey(ModelRepresentation modelRepresentation) {
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey((Model)null, modelRepresentation.getModelType(), modelRepresentation.getKey());
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new ConflictingRequestException("Provided model key already exists: " + modelRepresentation.getKey());
        }
    }

    protected ModelRepresentation createNewModel(String name, String description, Integer modelType, String editorJson) {
        ModelRepresentation model = new ModelRepresentation();
        model.setName(name);
        model.setDescription(description);
        model.setModelType(modelType);
        Model newModel = this.modelService.createModel(model, editorJson, SecurityUtils.getCurrentUserId());
        return new ModelRepresentation((AbstractModel)newModel);
    }
}

