/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.extension.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.common.constant.CommonConstants;
import com.jeeplus.extension.domain.FlowAssignee;
import com.jeeplus.extension.domain.FlowButton;
import com.jeeplus.extension.domain.FlowCondition;
import com.jeeplus.extension.domain.TaskDefExtension;
import com.jeeplus.extension.mapper.TaskDefExtensionMapper;
import com.jeeplus.extension.service.FlowAssigneeService;
import com.jeeplus.extension.service.FlowButtonService;
import com.jeeplus.extension.service.FlowConditionService;
import com.jeeplus.extension.service.dto.FlowAssigneeDTO;
import com.jeeplus.extension.service.dto.FlowButtonDTO;
import com.jeeplus.extension.service.dto.FlowConditionDTO;
import com.jeeplus.extension.service.dto.TaskDefExtensionDTO;
import com.jeeplus.extension.service.mapstruct.FlowAssigneeWrapper;
import com.jeeplus.extension.service.mapstruct.FlowButtonWrapper;
import com.jeeplus.extension.service.mapstruct.FlowConditionWrapper;
import com.jeeplus.extension.service.mapstruct.TaskDefExtensionWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TaskDefExtensionService
extends ServiceImpl<TaskDefExtensionMapper, TaskDefExtension> {
    @Autowired
    private FlowAssigneeService flowAssigneeService;
    @Autowired
    private FlowButtonService flowButtonService;
    @Autowired
    private FlowConditionService flowConditionService;
    @Autowired
    private TaskDefExtensionWrapper taskDefExtensionWrapper;

    public TaskDefExtensionDTO getById(String id) {
        TaskDefExtensionDTO taskDefExtension = (TaskDefExtensionDTO)this.taskDefExtensionWrapper.toDTO(((TaskDefExtensionMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        taskDefExtension.setFlowAssigneeList(((LambdaQueryChainWrapper)this.flowAssigneeService.lambdaQuery().eq(FlowAssignee::getTaskDefId, (Object)id)).list().stream().map(arg_0 -> ((FlowAssigneeWrapper)FlowAssigneeWrapper.INSTANCE).toDTO(arg_0)).collect(Collectors.toList()));
        taskDefExtension.setFlowButtonList(((LambdaQueryChainWrapper)this.flowButtonService.lambdaQuery().eq(FlowButton::getTaskDefId, (Object)id)).list().stream().map(arg_0 -> ((FlowButtonWrapper)FlowButtonWrapper.INSTANCE).toDTO(arg_0)).collect(Collectors.toList()));
        taskDefExtension.setFlowConditionList(((LambdaQueryChainWrapper)this.flowConditionService.lambdaQuery().eq(FlowCondition::getTaskDefId, (Object)id)).list().stream().map(arg_0 -> ((FlowConditionWrapper)FlowConditionWrapper.INSTANCE).toDTO(arg_0)).collect(Collectors.toList()));
        return taskDefExtension;
    }

    public void save(TaskDefExtensionDTO taskDefExtensionDTO) {
        TaskDefExtension taskDefExtension = (TaskDefExtension)this.taskDefExtensionWrapper.toEntity((Object)taskDefExtensionDTO);
        super.saveOrUpdate((Object)taskDefExtension);
        for (FlowAssigneeDTO flowAssigneeDTO : taskDefExtensionDTO.getFlowAssigneeList()) {
            if (flowAssigneeDTO.getId() == null) continue;
            if (CommonConstants.DELETED.equals(flowAssigneeDTO.getDelFlag())) {
                this.flowAssigneeService.removeById((Serializable)((Object)flowAssigneeDTO.getId()));
                continue;
            }
            FlowAssignee flowAssignee = FlowAssigneeWrapper.INSTANCE.toEntity(flowAssigneeDTO);
            flowAssignee.setTaskDefId(taskDefExtension.getId());
            this.flowAssigneeService.saveOrUpdate((Object)flowAssignee);
        }
        for (FlowButtonDTO flowButtonDTO : taskDefExtensionDTO.getFlowButtonList()) {
            if (flowButtonDTO.getId() == null) continue;
            if (CommonConstants.DELETED.equals(flowButtonDTO.getDelFlag())) {
                this.flowButtonService.removeById((Serializable)((Object)flowButtonDTO.getId()));
                continue;
            }
            FlowButton flowButton = FlowButtonWrapper.INSTANCE.toEntity(flowButtonDTO);
            flowButton.setTaskDefId(taskDefExtension.getId());
            this.flowButtonService.saveOrUpdate((Object)flowButton);
        }
        for (FlowConditionDTO flowConditionDTO : taskDefExtensionDTO.getFlowConditionList()) {
            if (flowConditionDTO.getId() == null) continue;
            if (CommonConstants.DELETED.equals(flowConditionDTO.getDelFlag())) {
                this.flowConditionService.removeById((Serializable)((Object)flowConditionDTO.getId()));
                continue;
            }
            FlowCondition flowCondition = FlowConditionWrapper.INSTANCE.toEntity(flowConditionDTO);
            flowCondition.setTaskDefId(taskDefExtension.getId());
            this.flowConditionService.save((Object)flowCondition);
        }
    }

    public void delete(String id) {
        this.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.flowAssigneeService.lambdaUpdate().eq(FlowAssignee::getTaskDefId, (Object)id)).remove();
        ((LambdaUpdateChainWrapper)this.flowButtonService.lambdaUpdate().eq(FlowButton::getTaskDefId, (Object)id)).remove();
        ((LambdaUpdateChainWrapper)this.flowConditionService.lambdaUpdate().eq(FlowCondition::getTaskDefId, (Object)id)).remove();
    }

    public void deleteByProcessDefId(String processDefId) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TaskDefExtension::getProcessDefId, (Object)processDefId)).list();
        for (TaskDefExtension taskDefExtension : list) {
            String id = taskDefExtension.getId();
            this.delete(id);
        }
    }
}

