/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.extension.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.extension.domain.TaskDefExtension;
import com.jeeplus.extension.service.TaskDefExtensionService;
import com.jeeplus.extension.service.dto.TaskDefExtensionDTO;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/extension/taskDefExtension"})
public class TaskDefExtensionController {
    @Autowired
    private TaskDefExtensionService taskDefExtensionService;

    @GetMapping(value={"list"})
    public ResponseEntity list(TaskDefExtension taskDefExtension, Page<TaskDefExtension> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)taskDefExtension, TaskDefExtension.class);
        IPage result = this.taskDefExtensionService.page(page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity<TaskDefExtensionDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.taskDefExtensionService.getById(id));
    }

    @GetMapping(value={"queryByDefIdAndTaskId"})
    public ResponseEntity<TaskDefExtensionDTO> queryByDefIdAndTaskId(TaskDefExtensionDTO taskDefExtension) throws Exception {
        if (StrUtil.isBlank((CharSequence)taskDefExtension.getProcessDefId()) || StrUtil.isBlank((CharSequence)taskDefExtension.getTaskDefId())) {
            return ResponseEntity.ok(null);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskDefExtensionService.lambdaQuery().eq(TaskDefExtension::getProcessDefId, (Object)taskDefExtension.getProcessDefId())).eq(TaskDefExtension::getTaskDefId, (Object)taskDefExtension.getTaskDefId())).list();
        if (list.size() > 1) {
            throw new Exception("\u91cd\u590d\u7684task id\u5b9a\u4e49!");
        }
        if (list.size() == 1) {
            String id = ((TaskDefExtension)list.get(0)).getId();
            return ResponseEntity.ok((Object)this.taskDefExtensionService.getById(id));
        }
        return ResponseEntity.ok((Object)taskDefExtension);
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody List<TaskDefExtensionDTO> taskDefExtensionList) {
        for (TaskDefExtensionDTO taskDefExtension : taskDefExtensionList) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskDefExtensionService.lambdaQuery().eq(TaskDefExtension::getProcessDefId, (Object)taskDefExtension.getProcessDefId())).eq(TaskDefExtension::getTaskDefId, (Object)taskDefExtension.getTaskDefId())).list();
            for (TaskDefExtension defExtension : list) {
                this.taskDefExtensionService.delete(defExtension.getId());
            }
            this.taskDefExtensionService.save(taskDefExtension);
        }
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u5de5\u4f5c\u6d41\u6269\u5c55\u6210\u529f");
    }

    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(String ids) {
        Object[] idArray = ids.split(",");
        this.taskDefExtensionService.removeByIds((Collection)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5de5\u4f5c\u6d41\u6269\u5c55\u6210\u529f");
    }
}

