/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.onetomany.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.common.constant.CommonConstants;
import com.jeeplus.test.onetomany.domain.TestDataChild1;
import com.jeeplus.test.onetomany.domain.TestDataChild2;
import com.jeeplus.test.onetomany.domain.TestDataChild3;
import com.jeeplus.test.onetomany.domain.TestDataMain;
import com.jeeplus.test.onetomany.mapper.TestDataMainMapper;
import com.jeeplus.test.onetomany.service.TestDataChild1Service;
import com.jeeplus.test.onetomany.service.TestDataChild2Service;
import com.jeeplus.test.onetomany.service.TestDataChild3Service;
import com.jeeplus.test.onetomany.service.dto.TestDataChild1DTO;
import com.jeeplus.test.onetomany.service.dto.TestDataChild2DTO;
import com.jeeplus.test.onetomany.service.dto.TestDataChild3DTO;
import com.jeeplus.test.onetomany.service.dto.TestDataMainDTO;
import com.jeeplus.test.onetomany.service.mapstruct.TestDataChild1Wrapper;
import com.jeeplus.test.onetomany.service.mapstruct.TestDataChild2Wrapper;
import com.jeeplus.test.onetomany.service.mapstruct.TestDataChild3Wrapper;
import com.jeeplus.test.onetomany.service.mapstruct.TestDataMainWrapper;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TestDataMainService
extends ServiceImpl<TestDataMainMapper, TestDataMain> {
    @Autowired
    private TestDataChild1Service testDataChild1Service;
    @Autowired
    private TestDataChild2Service testDataChild2Service;
    @Autowired
    private TestDataChild3Service testDataChild3Service;

    public TestDataMainDTO findById(String id) {
        TestDataMainDTO testDataMainDTO = ((TestDataMainMapper)this.baseMapper).findById(id);
        testDataMainDTO.setTestDataChild1DTOList(this.testDataChild1Service.findList(id));
        testDataMainDTO.setTestDataChild2DTOList(this.testDataChild2Service.findList(id));
        testDataMainDTO.setTestDataChild3DTOList(this.testDataChild3Service.findList(id));
        return testDataMainDTO;
    }

    public IPage<TestDataMainDTO> findPage(Page<TestDataMainDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)0);
        return ((TestDataMainMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public void saveOrUpdate(TestDataMainDTO testDataMainDTO) {
        TestDataMain testDataMain = TestDataMainWrapper.INSTANCE.toEntity(testDataMainDTO);
        super.saveOrUpdate((Object)testDataMain);
        for (TestDataChild1DTO testDataChild1DTO : testDataMainDTO.getTestDataChild1DTOList()) {
            if (CommonConstants.DELETED.equals(testDataChild1DTO.getDelFlag())) {
                this.testDataChild1Service.removeById((Serializable)((Object)testDataChild1DTO.getId()));
                continue;
            }
            TestDataChild1 testDataChild1 = TestDataChild1Wrapper.INSTANCE.toEntity(testDataChild1DTO);
            testDataChild1.setTestDataMainId(testDataMain.getId());
            this.testDataChild1Service.saveOrUpdate((Object)testDataChild1);
        }
        for (TestDataChild2DTO testDataChild2DTO : testDataMainDTO.getTestDataChild2DTOList()) {
            if (CommonConstants.DELETED.equals(testDataChild2DTO.getDelFlag())) {
                this.testDataChild2Service.removeById((Serializable)((Object)testDataChild2DTO.getId()));
                continue;
            }
            TestDataChild2 testDataChild2 = TestDataChild2Wrapper.INSTANCE.toEntity(testDataChild2DTO);
            testDataChild2.setTestDataMainId(testDataMain.getId());
            this.testDataChild2Service.saveOrUpdate((Object)testDataChild2);
        }
        for (TestDataChild3DTO testDataChild3DTO : testDataMainDTO.getTestDataChild3DTOList()) {
            if (CommonConstants.DELETED.equals(testDataChild3DTO.getDelFlag())) {
                this.testDataChild3Service.removeById((Serializable)((Object)testDataChild3DTO.getId()));
                continue;
            }
            TestDataChild3 testDataChild3 = TestDataChild3Wrapper.INSTANCE.toEntity(testDataChild3DTO);
            testDataChild3.setTestDataMainId(testDataMain.getId());
            this.testDataChild3Service.saveOrUpdate((Object)testDataChild3);
        }
    }

    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.testDataChild1Service.lambdaUpdate().eq(TestDataChild1::getTestDataMainId, (Object)id)).remove();
        ((LambdaUpdateChainWrapper)this.testDataChild2Service.lambdaUpdate().eq(TestDataChild2::getTestDataMainId, (Object)id)).remove();
        ((LambdaUpdateChainWrapper)this.testDataChild3Service.lambdaUpdate().eq(TestDataChild3::getTestDataMainId, (Object)id)).remove();
    }
}

