/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.excel.converter;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.jeeplus.sys.feign.IOfficeApi;
import com.jeeplus.sys.service.dto.OfficeDTO;

public class ExcelOfficeDTOConverter
implements Converter<OfficeDTO> {
    public Class<?> supportJavaTypeKey() {
        return OfficeDTO.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public OfficeDTO convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String val = cellData.getStringValue();
        OfficeDTO officeDTO = ((IOfficeApi)SpringUtil.getBean(IOfficeApi.class)).getOfficeDTOByName(val);
        return officeDTO;
    }

    public WriteCellData<?> convertToExcelData(OfficeDTO value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (value != null && value.getName() != null) {
            return new WriteCellData(value.getName());
        }
        return new WriteCellData("");
    }
}

