/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service.converter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.jeeplus.extension.domain.FlowAssignee;
import com.jeeplus.extension.domain.FlowButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.UserTaskJsonConverter;

public class FlowUserTaskJsonConverter
extends UserTaskJsonConverter {
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        JsonNode assignees;
        JsonNode buttons;
        UserTask flowElement = (UserTask)super.convertJsonToElement(elementNode, modelNode, shapeMap, converterContext);
        if (this.getPropertyValueAsString("formReadOnly", elementNode) != null) {
            ExtensionAttribute attribute = new ExtensionAttribute();
            attribute.setName("flowable:formReadOnly");
            attribute.setValue(this.getPropertyValueAsString("formReadOnly", elementNode));
            flowElement.addAttribute(attribute);
        }
        if ((buttons = this.getProperty("button", elementNode)) != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                ExtensionElement button = new ExtensionElement();
                button.setName("flowable:Button");
                ExtensionAttribute code = new ExtensionAttribute();
                code.setName("code");
                code.setValue(this.getValueAsString("code", buttons.get(i)));
                ExtensionAttribute name = new ExtensionAttribute();
                name.setName("name");
                name.setValue(this.getValueAsString("name", buttons.get(i)));
                ExtensionAttribute next = new ExtensionAttribute();
                next.setName("next");
                next.setValue(this.getValueAsString("next", buttons.get(i)));
                ExtensionAttribute isHide = new ExtensionAttribute();
                isHide.setName("isHide");
                isHide.setValue(this.getValueAsString("isHide", buttons.get(i)));
                ExtensionAttribute sort = new ExtensionAttribute();
                sort.setName("sort");
                sort.setValue(this.getValueAsString("sort", buttons.get(i)));
                button.addAttribute(code);
                button.addAttribute(name);
                button.addAttribute(next);
                button.addAttribute(isHide);
                button.addAttribute(sort);
                flowElement.addExtensionElement(button);
            }
        }
        if ((assignees = this.getProperty("assignee", elementNode)) != null) {
            for (int i = 0; i < assignees.size(); ++i) {
                ExtensionElement assignee = new ExtensionElement();
                assignee.setName("flowable:Assignee");
                ExtensionAttribute type = new ExtensionAttribute();
                type.setName("type");
                type.setValue(this.getValueAsString("type", assignees.get(i)));
                ExtensionAttribute value = new ExtensionAttribute();
                value.setName("value");
                value.setValue(this.getValueAsString("value", assignees.get(i)));
                ExtensionAttribute condition = new ExtensionAttribute();
                condition.setName("condition");
                condition.setValue(this.getValueAsString("condition", assignees.get(i)));
                ExtensionAttribute operationType = new ExtensionAttribute();
                operationType.setName("operationType");
                operationType.setValue(this.getValueAsString("operationType", assignees.get(i)));
                ExtensionAttribute sort = new ExtensionAttribute();
                sort.setName("sort");
                sort.setValue(this.getValueAsString("sort", assignees.get(i)));
                assignee.addAttribute(type);
                assignee.addAttribute(value);
                assignee.addAttribute(condition);
                assignee.addAttribute(operationType);
                assignee.addAttribute(sort);
                flowElement.addExtensionElement(assignee);
            }
        }
        if (this.getPropertyValueAsString("formType", elementNode) != null) {
            ExtensionAttribute attribute2 = new ExtensionAttribute();
            attribute2.setName("flowable:formType");
            attribute2.setValue(this.getPropertyValueAsString("formType", elementNode));
            flowElement.addAttribute(attribute2);
        }
        return flowElement;
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        super.convertElementToJson(propertiesNode, baseElement, converterContext);
        if (baseElement instanceof UserTask) {
            if (baseElement.getAttributes().get("formType") != null && ((List)baseElement.getAttributes().get("formType")).size() > 0) {
                propertiesNode.put("formType", ((ExtensionAttribute)((List)baseElement.getAttributes().get("formType")).get(0)).getValue());
            }
            if (baseElement.getAttributes().get("formReadOnly") != null && ((List)baseElement.getAttributes().get("formReadOnly")).size() > 0) {
                propertiesNode.put("formReadOnly", ((ExtensionAttribute)((List)baseElement.getAttributes().get("formReadOnly")).get(0)).getValue());
            }
            ArrayList buttons = Lists.newArrayList();
            ArrayList assignees = Lists.newArrayList();
            baseElement.getExtensionElements().forEach((s, elements) -> elements.forEach(extensionElement -> {
                if ("button".equals(extensionElement.getName())) {
                    buttons.add(extensionElement);
                }
                if ("assignee".equals(extensionElement.getName())) {
                    assignees.add(extensionElement);
                }
            }));
            this.addButtonProperties((List)buttons, propertiesNode);
            this.addAssigneeProperties((List)assignees, propertiesNode);
        }
    }

    protected void addAssigneeProperties(List<ExtensionElement> elements, ObjectNode propertiesNode) {
        if (elements.size() == 0) {
            return;
        }
        ArrayNode propertiesArrayNode = this.objectMapper.createArrayNode();
        ArrayList flowAssignees = Lists.newArrayList();
        elements.forEach(extensionElement -> {
            FlowAssignee flowAssignee = new FlowAssignee();
            flowAssignee.setType(((ExtensionAttribute)((List)extensionElement.getAttributes().get("type")).get(0)).getValue());
            flowAssignee.setValue(((ExtensionAttribute)((List)extensionElement.getAttributes().get("value")).get(0)).getValue());
            flowAssignee.setCondition(((ExtensionAttribute)((List)extensionElement.getAttributes().get("condition")).get(0)).getValue());
            flowAssignee.setOperationType(((ExtensionAttribute)((List)extensionElement.getAttributes().get("operationType")).get(0)).getValue());
            flowAssignee.setSort(Integer.valueOf(((ExtensionAttribute)((List)extensionElement.getAttributes().get("sort")).get(0)).getValue()));
            flowAssignees.add(flowAssignee);
        });
        for (FlowAssignee flowAssignee : flowAssignees) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("type", flowAssignee.getType());
            propertyItemNode.put("value", flowAssignee.getValue());
            propertyItemNode.put("condition", flowAssignee.getCondition());
            propertyItemNode.put("operationType", flowAssignee.getOperationType());
            propertyItemNode.put("sort", flowAssignee.getSort());
            propertiesArrayNode.add((JsonNode)propertyItemNode);
        }
        propertiesNode.set("assignee", (JsonNode)propertiesArrayNode);
    }

    protected void addButtonProperties(List<ExtensionElement> elements, ObjectNode propertiesNode) {
        if (elements.size() == 0) {
            return;
        }
        ArrayNode propertiesArrayNode = this.objectMapper.createArrayNode();
        ArrayList flowButtons = Lists.newArrayList();
        elements.forEach(extensionElement -> {
            FlowButton flowButton = new FlowButton();
            flowButton.setName(((ExtensionAttribute)((List)extensionElement.getAttributes().get("name")).get(0)).getValue());
            flowButton.setCode(((ExtensionAttribute)((List)extensionElement.getAttributes().get("code")).get(0)).getValue());
            flowButton.setIsHide(((ExtensionAttribute)((List)extensionElement.getAttributes().get("isHide")).get(0)).getValue());
            flowButton.setSort(Integer.valueOf(((ExtensionAttribute)((List)extensionElement.getAttributes().get("sort")).get(0)).getValue()));
            flowButtons.add(flowButton);
        });
        for (FlowButton flowButton : flowButtons) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("name", flowButton.getName());
            propertyItemNode.put("code", flowButton.getCode());
            propertyItemNode.put("isHide", flowButton.getIsHide());
            propertyItemNode.put("sort", flowButton.getSort());
            propertiesArrayNode.add((JsonNode)propertyItemNode);
        }
        propertiesNode.set("button", (JsonNode)propertiesArrayNode);
    }
}

