/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.channel.ConnectTimeoutException;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ControllerAdvice
@Configuration(value="jpExceptionTranslator")
public class GatewayExceptionHandler
implements ErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GatewayExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        String msg;
        ServerHttpResponse response = exchange.getResponse();
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        if (ex instanceof NotFoundException) {
            msg = "\u670d\u52a1\u672a\u627e\u5230";
            response.setStatusCode(HttpStatus.NOT_FOUND);
        } else if (ex instanceof ConnectTimeoutException) {
            msg = "\u8bf7\u6c42\u670d\u52a1\u8d85\u65f6";
            response.setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
        } else if (ex instanceof AccessDeniedException) {
            msg = ex.getMessage();
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
        } else if (ex instanceof MissingServletRequestPartException || ex instanceof MissingServletRequestParameterException) {
            msg = "\u60a8\u63d0\u4ea4\u7684\u53c2\u6570\uff0c\u670d\u52a1\u5668\u65e0\u6cd5\u5904\u7406";
            response.setStatusCode(HttpStatus.BAD_REQUEST);
        } else if (ex instanceof MethodArgumentNotValidException) {
            ObjectError error = (ObjectError)((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors().get(0);
            String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
            msg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
            response.setStatusCode(HttpStatus.BAD_REQUEST);
        } else if (ex instanceof BindException) {
            ObjectError error = (ObjectError)((BindException)ex).getBindingResult().getAllErrors().get(0);
            String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
            msg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
            response.setStatusCode(HttpStatus.BAD_REQUEST);
        } else if (ex instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)ex;
            response.setStatusCode(responseStatusException.getStatus());
            msg = responseStatusException.getMessage();
        } else {
            msg = "\u5185\u90e8\u9519\u8bef: " + ex.getMessage();
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        log.error("[\u7f51\u5173\u5f02\u5e38\u5904\u7406]\u8bf7\u6c42\u8def\u5f84:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)exchange.getRequest().getPath(), (Object)ex.getMessage());
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            return bufferFactory.wrap(JSON.toJSONBytes((Object)msg, (SerializerFeature[])new SerializerFeature[0]));
        }));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        ObjectError error = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
        String errMsg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
        log.error("{}", (Throwable)e);
        return new ResponseEntity((Object)errMsg, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity handleBindException(BindException e) {
        ObjectError error = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        String[] str = Objects.requireNonNull(error.getCodes())[1].split("\\.");
        String errMsg = "\u53c2\u6570" + str[1] + ", \u6570\u636e\u9a8c\u8bc1\u5931\u8d25:" + error.getDefaultMessage();
        log.error("{}", (Throwable)e);
        return new ResponseEntity((Object)errMsg, HttpStatus.BAD_REQUEST);
    }
}

