/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.file.repository;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.jeeplus.file.repository.AccessoryRepository;
import com.jeeplus.file.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"config.accessory.type"}, havingValue="aliyun")
public class AliyunOSSRepository
implements AccessoryRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${config.accessory.baseDir}")
    private String accessoryBaseDir;
    @Value(value="${config.accessory.aliyun.endpoint}")
    private String endpoint;
    @Value(value="${config.accessory.aliyun.accessKeyId}")
    private String accessKeyId;
    @Value(value="${config.accessory.aliyun.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${config.accessory.aliyun.bucketName}")
    private String bucketName;

    public File get(String path, String fileName) throws FileNotFoundException {
        this.logger.debug("\u5f00\u59cb\u4ecealiyun-oss\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{path, "/", fileName});
        long begin = System.currentTimeMillis();
        try {
            if (path == null) {
                path = "";
            }
            OSS client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            OSSObject object = client.getObject(this.bucketName, this.accessoryBaseDir + "/" + path + "/" + fileName);
            InputStream is = object.getObjectContent();
            File localTempDir = new File(FileUtils.getTempDirectory() + File.separator + this.accessoryBaseDir + File.separator + path);
            FileUtils.createDirectory((String)localTempDir.getPath());
            File dest = new File(localTempDir, fileName);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
            is.close();
            client.shutdown();
            File file = dest;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OSSException e) {
            throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        finally {
            this.logger.debug("\u5b8c\u6210\u4ecealiyun-oss\u83b7\u53d6\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        }
        return null;
    }

    public String getURL(String path, String fileName, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        String string;
        this.logger.debug("\u5f00\u59cb\u4ecealiyun-oss\u83b7\u53d6\u6587\u4ef6: {}{}{}", new Object[]{path, "/", fileName});
        long begin = System.currentTimeMillis();
        URL downloadURL = null;
        try {
            if (path == null) {
                path = "";
            }
            OSS client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            Date expireDate = DateUtils.addHours((Date)new Date(), (int)1);
            downloadURL = client.generatePresignedUrl(this.bucketName, path + (path.endsWith("/") ? "" : "/") + fileName, expireDate);
            string = downloadURL.toString();
        }
        catch (OSSException e) {
            try {
                throw new FileNotFoundException("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            catch (Throwable throwable) {
                this.logger.debug("\u5b8c\u6210\u4ecealiyun-oss\u83b7\u53d6\u6587\u4ef6\u4e34\u65f6\u6388\u6743\u8def\u5f84 {}, \u8017\u65f6: {}", downloadURL, (Object)(System.currentTimeMillis() - begin));
                throw throwable;
            }
        }
        this.logger.debug("\u5b8c\u6210\u4ecealiyun-oss\u83b7\u53d6\u6587\u4ef6\u4e34\u65f6\u6388\u6743\u8def\u5f84 {}, \u8017\u65f6: {}", (Object)downloadURL, (Object)(System.currentTimeMillis() - begin));
        return string;
    }

    public File save(File file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        OSS client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentDisposition("attachment;filename=" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1));
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, this.accessoryBaseDir + "/" + path + "/" + fileName, file, meta);
        client.putObject(putObjectRequest);
        client.shutdown();
        this.logger.debug("\u5b8c\u6210\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return file;
    }

    public File save(MultipartFile file, String path, String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        try {
            OSS client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentDisposition("attachment;filename=" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1));
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, path + (path.endsWith("/") ? "" : "/") + fileName, file.getInputStream(), meta);
            client.putObject(putObjectRequest);
            client.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5b8c\u6210\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return null;
    }

    public File save(InputStream is, String path, @NotNull String fileName) {
        this.logger.debug("\u5f00\u59cb\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)fileName);
        long begin = System.currentTimeMillis();
        try {
            OSS client = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentDisposition("attachment;filename=" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1));
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, this.accessoryBaseDir + "/" + path + (path.endsWith("/") ? "" : "/") + fileName, is, meta);
            client.putObject(putObjectRequest);
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5b8c\u6210\u5411aliyun-oss\u4fdd\u5b58\u6587\u4ef6: {}", (Object)(System.currentTimeMillis() - begin));
        return null;
    }

    public String writeByUrl(MultipartFile file, String url) {
        return null;
    }
}

