/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.gateway.excepiton;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class JwtAccessDeniedHandler
implements ServerAccessDeniedHandler {
    private static final Logger log = LoggerFactory.getLogger(JwtAccessDeniedHandler.class);
    @Autowired
    private ObjectMapper mapper;

    public Mono<Void> handle(ServerWebExchange exchange, AccessDeniedException e) {
        log.error("\u6743\u9650\u4e0d\u8db3\uff1a" + e.getMessage());
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.FORBIDDEN);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            DataBuffer buffer = response.bufferFactory().wrap(this.mapper.writeValueAsBytes((Object)("\u6743\u9650\u4e0d\u8db3\uff1a" + e.getMessage())));
            return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError(error -> DataBufferUtils.release((DataBuffer)buffer));
        }
        catch (JsonProcessingException var5) {
            return Mono.error((Throwable)var5);
        }
    }
}

