/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service.ext.iml;

import cn.hutool.extra.spring.SpringUtil;
import com.google.common.collect.Lists;
import com.jeeplus.flowable.utils.FlowableUtils;
import com.jeeplus.sys.feign.ITenantApi;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.RoleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.impl.GroupQueryImpl;

public class FlowGroupQueryImpl
extends GroupQueryImpl {
    private static final long serialVersionUID = 1L;

    public long executeCount(CommandContext commandContext) {
        return this.executeQuery().size();
    }

    public List<Group> executeList(CommandContext commandContext) {
        return this.executeQuery();
    }

    protected List<Group> executeQuery() {
        if (this.getUserId() != null) {
            return this.findGroupsByUser(this.getUserId());
        }
        return this.findAllGroups();
    }

    protected List<Group> findGroupsByUser(String userId) {
        ArrayList list = Lists.newArrayList();
        String tenantId = ((ITenantApi)SpringUtil.getBean(ITenantApi.class)).getCurrentTenantId();
        UserDTO user = ((IUserApi)SpringUtil.getBean(IUserApi.class)).getByLoginName(userId, tenantId);
        if (user != null && user.getRoleDTOList() != null) {
            for (RoleDTO role : user.getRoleDTOList()) {
                list.add(FlowableUtils.toFlowableGroup((RoleDTO)role));
            }
        }
        return list;
    }

    protected List<Group> findAllGroups() {
        return new ArrayList<Group>();
    }
}

