/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.service;

import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowableBpmnModelService {
    @Autowired
    private RepositoryService repositoryService;

    public BpmnModel getBpmnModelByProcessDefId(String processDefId) {
        return this.repositoryService.getBpmnModel(processDefId);
    }

    public List<FlowNode> findFlowNodes(String processDefId) {
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        Process process = bpmnModel.getMainProcess();
        Collection list = process.getFlowElements();
        list.forEach(flowElement -> {
            if (flowElement instanceof FlowNode) {
                flowNodes.add((FlowNode)flowElement);
            }
        });
        return flowNodes;
    }

    public List<EndEvent> findEndFlowElement(String processDefId) {
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        if (bpmnModel != null) {
            Process process = bpmnModel.getMainProcess();
            return process.findFlowElementsOfType(EndEvent.class);
        }
        return null;
    }

    public FlowNode findMainProcessActivityByActivityId(String processDefId, String activityId) {
        FlowNode activity = null;
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        Process process = bpmnModel.getMainProcess();
        FlowElement flowElement = process.getFlowElement(activityId);
        if (flowElement != null) {
            activity = (FlowNode)flowElement;
        }
        return activity;
    }

    public FlowNode findFlowNodeByActivityId(String processDefId, String activityId) {
        FlowNode activity = null;
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        List processes = bpmnModel.getProcesses();
        for (Process process : processes) {
            FlowElement flowElement = (FlowElement)process.getFlowElementMap().get(activityId);
            if (flowElement == null) continue;
            activity = (FlowNode)flowElement;
            break;
        }
        return activity;
    }

    public boolean checkActivitySubprocessByActivityId(String processDefId, String activityId) {
        boolean flag = true;
        List activities = this.findFlowNodesByActivityId(processDefId, activityId);
        if (CollectionUtil.isNotEmpty((Collection)activities)) {
            flag = false;
        }
        return flag;
    }

    public List<FlowNode> findFlowNodesByActivityId(String processDefId, String activityId) {
        ArrayList<FlowNode> activities = new ArrayList<FlowNode>();
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        List processes = bpmnModel.getProcesses();
        for (Process process : processes) {
            FlowElement flowElement = process.getFlowElement(activityId);
            if (flowElement == null) continue;
            FlowNode flowNode = (FlowNode)flowElement;
            activities.add(flowNode);
        }
        return activities;
    }

    public List<Activity> findActivityByActivityId(String processDefId, String activityId) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        List processes = bpmnModel.getProcesses();
        for (Process process : processes) {
            FlowElement flowElement = process.getFlowElement(activityId);
            if (flowElement == null) continue;
            Activity activity = (Activity)flowElement;
            activities.add(activity);
        }
        return activities;
    }

    public Activity findActivityByName(String processDefId, String name) {
        Activity activity = null;
        BpmnModel bpmnModel = this.getBpmnModelByProcessDefId(processDefId);
        Process process = bpmnModel.getMainProcess();
        Collection list = process.getFlowElements();
        for (FlowElement f : list) {
            if (!StringUtils.isNotBlank((String)name) || !name.equals(f.getName())) continue;
            activity = (Activity)f;
            break;
        }
        return activity;
    }
}

