/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.domain.TreeMapper;
import com.jeeplus.core.dto.DragNode;
import com.jeeplus.core.service.dto.TreeDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class TreeService<D extends TreeMapper<T>, T extends TreeEntity<T>>
extends ServiceImpl<D, T> {
    private static final Logger log = LoggerFactory.getLogger(TreeService.class);

    public boolean saveOrUpdate(T entity) {
        TreeEntity parent = TreeDTO.getRootId().equals(entity.getParentId()) || StrUtil.isBlank((CharSequence)entity.getParentId()) ? null : (TreeEntity)super.getById((Serializable)((Object)entity.getParentId()));
        if (parent == null) {
            try {
                parent = (TreeEntity)this.entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                parent.setId(TreeDTO.getRootId());
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
            }
            entity.setParentId(parent.getId());
            parent.setParentIds("");
        }
        String oldParentIds = StrUtil.isNotBlank((CharSequence)entity.getId()) ? ((TreeEntity)super.getById((Serializable)((Object)entity.getId()))).getParentIds() : null;
        entity.setParentIds(parent.getParentIds() + parent.getId() + ",");
        super.saveOrUpdate(entity);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper(entity.getClass()).like(TreeEntity::getParentIds, (Object)("," + entity.getId() + ","));
        List list = super.list((Wrapper)queryWrapper);
        for (TreeEntity e : list) {
            if (e.getParentIds() == null || oldParentIds == null) continue;
            e.setParentIds(e.getParentIds().replace(oldParentIds, entity.getParentIds()));
            super.updateById((Object)e);
        }
        return true;
    }

    public void sortList(DragNode<T> dragNode) {
        String dropType = dragNode.getDropType();
        TreeEntity dropNode = (TreeEntity)dragNode.getDropNode();
        TreeEntity draggingNode = (TreeEntity)dragNode.getDraggingNode();
        String parentId = dropNode.getParentId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(dropNode.getClass()).eq(TreeEntity::getParentId, (Object)parentId)).orderByAsc(TreeEntity::getSort);
        List sourceList = super.list((Wrapper)queryWrapper);
        if ("inner".equals(dropType)) {
            draggingNode.setParentId(dropNode.getId());
            int size = sourceList.size();
            if (size > 0) {
                draggingNode.setSort(Integer.valueOf(((TreeEntity)sourceList.get(size - 1)).getSort() + 30));
            } else {
                draggingNode.setSort(Integer.valueOf(30));
            }
            this.saveOrUpdate((T)draggingNode);
        } else {
            int i;
            draggingNode.setParentId(dropNode.getParentId());
            ArrayList list = Lists.newArrayList();
            TreeEntity before = null;
            TreeEntity after = null;
            for (i = 0; i < sourceList.size(); ++i) {
                TreeEntity e = (TreeEntity)sourceList.get(i);
                if (!parentId.equals(e.getParentId())) continue;
                if (e.getId().equals(dropNode.getId())) {
                    if ("before".equals(dropType)) {
                        after = e;
                        if (i - 1 >= 0) {
                            before = (TreeEntity)sourceList.get(i - 1);
                        }
                        list.add(draggingNode);
                        list.add(e);
                        continue;
                    }
                    before = e;
                    if (i + 1 < sourceList.size()) {
                        after = (TreeEntity)sourceList.get(i + 1);
                    }
                    list.add(e);
                    list.add(draggingNode);
                    continue;
                }
                if (e.getId().equals(draggingNode.getId())) continue;
                list.add(e);
            }
            if (before == null && after != null && after.getSort() >= 1) {
                draggingNode.setSort(Integer.valueOf(after.getSort() / 2));
                this.saveOrUpdate((T)draggingNode);
            } else if (after == null && before != null) {
                draggingNode.setSort(Integer.valueOf(before.getSort() + 30));
                this.saveOrUpdate((T)draggingNode);
            } else if (before != null && after != null && after.getSort() - 2 >= before.getSort()) {
                draggingNode.setSort(Integer.valueOf((after.getSort() + before.getSort()) / 2));
                this.saveOrUpdate((T)draggingNode);
            } else {
                for (i = 0; i < list.size(); ++i) {
                    TreeEntity entity = (TreeEntity)list.get(i);
                    entity.setSort(Integer.valueOf((i + 1) * 30));
                    this.saveOrUpdate((T)entity);
                }
            }
        }
    }

    public List<T> getChildren(T parent) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper(parent.getClass()).eq(TreeEntity::getParentId, (Object)parent.getId());
        return super.list((Wrapper)queryWrapper);
    }

    public boolean removeWithChildrenById(String id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(this.entityClass).like(StrUtil.isNotBlank((CharSequence)id), TreeEntity::getParentIds, (Object)("," + id + ","))).or()).eq(StrUtil.isNotBlank((CharSequence)id), BaseEntity::getId, (Object)id);
        return super.remove((Wrapper)queryWrapper);
    }

    public void removeWithChildrenByIds(List<String> idList) {
        idList.stream().forEach(this::removeWithChildrenById);
    }

    public List<T> treeData() {
        return this.treeData(null);
    }

    public List<T> treeData(String extId) {
        List allList = super.list((Wrapper)new LambdaQueryWrapper(this.entityClass).orderByAsc(TreeEntity::getSort));
        try {
            TreeEntity root = (TreeEntity)this.entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            root.setId(TreeDTO.getRootId());
            List<TreeEntity> rootTree = this.formatListToTree(root, allList, extId);
            return rootTree;
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            return null;
        }
    }

    public List<T> formatListToTree(T root, List<T> allList, String extId) {
        String rootId = root.getId();
        ArrayList trees = Lists.newArrayList();
        HashMap treeMap = Maps.newHashMap();
        for (TreeEntity entity : allList) {
            List entities = (List)treeMap.get(entity.getParentId());
            if (entities == null) {
                entities = Lists.newLinkedList();
            }
            if (!StrUtil.isBlank((CharSequence)extId) && (extId.equals(entity.getId()) || entity.getParentIds().indexOf("," + extId + ",") != -1)) continue;
            entities.add(entity);
            treeMap.put(entity.getParentId(), entities);
        }
        if (treeMap.get(rootId) == null || ((List)treeMap.get(rootId)).isEmpty()) {
            return trees;
        }
        List children = (List)treeMap.get(rootId);
        for (TreeEntity parent : children) {
            this.formatFillChildren(parent, treeMap);
            trees.add(parent);
        }
        if (StrUtil.equals((CharSequence)rootId, (CharSequence)TreeDTO.getRootId())) {
            return children;
        }
        root.setChildren((List)trees);
        return Lists.newArrayList((Object[])new TreeEntity[]{root});
    }

    private void formatFillChildren(T parent, Map<String, List<T>> treeMap) {
        List<T> children = treeMap.get(parent.getId());
        parent.setChildren(children);
        if (children != null && !children.isEmpty()) {
            for (TreeEntity child : children) {
                this.formatFillChildren(child, treeMap);
            }
        }
    }
}

