/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import java.util.List;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.variable.ParallelMultiInstanceLoopVariable;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class ParallelMultiInstanceLoopVariableType
implements VariableType {
    public static final String TYPE_NAME = "bpmnParallelMultiInstanceCompleted";
    protected static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final ProcessEngineConfigurationImpl processEngineConfiguration;

    public ParallelMultiInstanceLoopVariableType(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return false;
    }

    public boolean isAbleToStore(Object value) {
        return value instanceof ParallelMultiInstanceLoopVariable;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value instanceof ParallelMultiInstanceLoopVariable) {
            valueFields.setTextValue(((ParallelMultiInstanceLoopVariable)value).getExecutionId());
            valueFields.setTextValue2(((ParallelMultiInstanceLoopVariable)value).getType());
        } else {
            valueFields.setTextValue((String)null);
            valueFields.setTextValue2((String)null);
        }
    }

    public Object getValue(ValueFields valueFields) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        return commandContext != null ? this.getValue(valueFields, commandContext) : this.processEngineConfiguration.getCommandExecutor().execute(context -> this.getValue(valueFields, context));
    }

    protected Object getValue(ValueFields valueFields, CommandContext commandContext) {
        String multiInstanceRootId = valueFields.getTextValue();
        String type = valueFields.getTextValue2();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity multiInstanceRootExecution = (ExecutionEntity)executionEntityManager.findById(multiInstanceRootId);
        if (multiInstanceRootExecution == null) {
            return 0;
        }
        List childExecutions = multiInstanceRootExecution.getExecutions();
        int nrOfActiveInstances = (int)childExecutions.stream().filter(execution -> execution.isActive() && !(execution.getCurrentFlowElement() instanceof BoundaryEvent)).count();
        if ("completed".equals(type)) {
            Object nrOfInstancesValue = multiInstanceRootExecution.getVariable(NUMBER_OF_INSTANCES);
            int nrOfInstances = (Integer)(nrOfInstancesValue != null ? nrOfInstancesValue : Integer.valueOf(0));
            return nrOfInstances - nrOfActiveInstances;
        }
        return "active".equals(type) ? nrOfActiveInstances : 0;
    }

    public boolean isReadOnly() {
        return true;
    }
}

