/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.flowable.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.extension.domain.NodeSetting;
import com.jeeplus.extension.service.NodeSettingService;
import com.jeeplus.flowable.model.Flow;
import com.jeeplus.flowable.model.TaskComment;
import com.jeeplus.flowable.service.FlowTaskService;
import com.jeeplus.flowable.vo.HisTaskVo;
import com.jeeplus.flowable.vo.ProcessVo;
import com.jeeplus.mail.feign.IMailApi;
import com.jeeplus.sys.feign.IUserApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowable/task"})
public class FlowableTaskController {
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private NodeSettingService nodeSettingService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMailApi mailApi;

    @GetMapping(value={"todo"})
    public ResponseEntity todoListData(Page<ProcessVo> page, Flow flow) {
        page = this.flowTaskService.todoList(page, flow);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"historic"})
    public ResponseEntity historicListData(Page<HisTaskVo> page, Flow flow) {
        page = this.flowTaskService.historicList(page, flow);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"myApplyed"})
    public ResponseEntity myApplyedListData(Page<ProcessVo> page, Flow flow) throws Exception {
        page = this.flowTaskService.getMyStartedProcIns(this.userApi.getByToken(TokenProvider.getCurrentToken()), page, flow);
        return ResponseEntity.ok((Object)page);
    }

    @GetMapping(value={"historicTaskList"})
    public ResponseEntity historicTaskList(Flow flow) throws Exception {
        List historicTaskList = this.flowTaskService.historicTaskList(flow.getProcInsId());
        return ResponseEntity.ok((Object)historicTaskList);
    }

    @GetMapping(value={"getTaskDef"})
    public ResponseEntity getTaskDef(Flow flow) {
        String formKey = this.flowTaskService.getFormKey(flow.getProcDefId(), flow.getTaskDefKey());
        NodeSetting typeNode = this.nodeSettingService.queryByKey(flow.getProcDefKey(), flow.getTaskDefKey(), "formType");
        NodeSetting ReadOnlyNode = this.nodeSettingService.queryByKey(flow.getProcDefKey(), flow.getTaskDefKey(), "formReadOnly");
        String formType = "1";
        boolean formReadOnly = false;
        if (typeNode != null) {
            formType = typeNode.getValue();
            formReadOnly = "true".equals(ReadOnlyNode.getValue());
        } else if (StringUtils.isBlank((CharSequence)formKey)) {
            formType = "1";
        } else if (formKey.indexOf("/") >= 0) {
            formType = "2";
        }
        if (flow.getProcInsId() != null) {
            if (this.flowTaskService.getProcIns(flow.getProcInsId()) != null) {
                flow.setProcIns(this.flowTaskService.getProcIns(flow.getProcInsId()));
            } else {
                flow.setFinishedProcIns(this.flowTaskService.getFinishedProcIns(flow.getProcInsId()));
            }
        }
        flow.setFormUrl(formKey);
        flow.setFormReadOnly(formReadOnly);
        flow.setFormType(formType);
        return ResponseEntity.ok((Object)flow);
    }

    @PostMapping(value={"start"})
    public ResponseEntity start(@RequestBody Flow flow) {
        Task task;
        String procInsId = this.flowTaskService.startProcess(flow.getProcDefKey(), flow.getBusinessTable(), flow.getBusinessId(), flow.getTitle());
        if (StringUtils.isNotBlank((CharSequence)flow.getAssignee()) && (task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInsId)).active().singleResult()) != null) {
            this.taskService.setAssignee(task.getId(), flow.getAssignee());
        }
        return ResponseEntity.ok((Object)procInsId);
    }

    @PostMapping(value={"claim"})
    public ResponseEntity claim(@RequestBody Flow flow) {
        String userId = this.userApi.getByToken(TokenProvider.getCurrentToken()).getId();
        this.flowTaskService.claim(flow.getTaskId(), userId);
        return ResponseEntity.ok((Object)"\u7b7e\u6536\u6210\u529f!");
    }

    @PostMapping(value={"complete"})
    public ResponseEntity complete(@RequestBody Flow flow) {
        this.flowTaskService.complete(flow, flow.getVars().getVariableMap());
        return ResponseEntity.ok((Object)"\u5b8c\u6210\u4efb\u52a1!");
    }

    @GetMapping(value={"getFlowChart"})
    public Map getFlowChart(String processInstanceId) throws Exception {
        return this.flowTaskService.getDiagram(processInstanceId);
    }

    @DeleteMapping(value={"deleteTask"})
    public ResponseEntity deleteTask(String taskId, String reason) {
        if (StringUtils.isBlank((CharSequence)reason)) {
            return ResponseEntity.badRequest().body((Object)"\u8bf7\u586b\u5199\u5220\u9664\u539f\u56e0");
        }
        this.flowTaskService.deleteTask(taskId, reason);
        return ResponseEntity.ok((Object)("\u5220\u9664\u4efb\u52a1\u6210\u529f\uff0c\u4efb\u52a1ID=" + taskId));
    }

    @PostMapping(value={"addSignTask"})
    public ResponseEntity addSignTask(String taskId, String userIds, String comment, Boolean flag) throws Exception {
        this.flowTaskService.addSignTask(taskId, Arrays.asList(userIds.split(",")), comment, flag);
        return ResponseEntity.ok((Object)"\u52a0\u7b7e\u6210\u529f!");
    }

    @PostMapping(value={"audit"})
    public ResponseEntity auditTask(HttpServletRequest request, Flow flow) {
        Task task;
        HashMap vars = Maps.newHashMap();
        Map map = request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("vars.")) continue;
            String key = ((String)entry.getKey()).substring(5);
            String value = ((String[])entry.getValue())[0];
            if ("true".equals(value) || "false".equals(value)) {
                vars.put(key, Boolean.valueOf(Boolean.valueOf(value)));
                continue;
            }
            vars.put(key, value);
        }
        this.flowTaskService.auditSave(flow, (Map)vars);
        if (StringUtils.isNotBlank((CharSequence)flow.getAssignee()) && (task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(flow.getProcInsId())).active().singleResult()) != null) {
            this.taskService.setAssignee(task.getId(), flow.getAssignee());
        }
        return ResponseEntity.ok((Object)flow.getProcInsId());
    }

    @RequestMapping(value={"callback"})
    public ResponseEntity callback(@Param(value="preTaskId") String preTaskId, @Param(value="currentTaskId") String currentTaskId, @Param(value="processInstanceId") String processInstanceId, @Param(value="preTaskDefKey") String preTaskDefKey, @Param(value="currentTaskDefKey") String currentTaskDefKey) {
        try {
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (instance == null) {
                return ResponseEntity.badRequest().body((Object)"\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
            }
            this.historyService.deleteHistoricTaskInstance(preTaskId);
            ArrayList currTasks = Lists.newArrayList();
            currTasks.add(currentTaskDefKey);
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(instance.getId()).moveActivityIdsToSingleActivityId((List)currTasks, preTaskDefKey).changeState();
            this.historyService.deleteHistoricTaskInstance(currentTaskId);
            return ResponseEntity.ok((Object)"\u53d6\u56de\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body((Object)"\u6d41\u7a0b\u53d6\u56de\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef.");
        }
    }

    @RequestMapping(value={"delegate"})
    public ResponseEntity delegate(String taskId, String userId) {
        if (StringUtils.isBlank((CharSequence)taskId) || StringUtils.isBlank((CharSequence)userId)) {
            return ResponseEntity.badRequest().body((Object)"\u53c2\u6570\u5f02\u5e38");
        }
        this.taskService.setOwner(taskId, this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
        this.taskService.delegateTask(taskId, userId);
        return ResponseEntity.ok((Object)"\u59d4\u6258\u6210\u529f");
    }

    @RequestMapping(value={"unclaim"})
    public ResponseEntity unclaim(String taskId) {
        this.taskService.unclaim(taskId);
        return ResponseEntity.ok((Object)"\u53d6\u6d88\u7b7e\u6536\u6210\u529f");
    }

    @PutMapping(value={"transfer"})
    public ResponseEntity transferTask(String taskId, String userId) {
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)taskId)) {
            return ResponseEntity.badRequest().body((Object)"\u8f6c\u6d3e\u5931\u8d25, \u53c2\u6570\u5f02\u5e38");
        }
        Authentication.setAuthenticatedUserId((String)this.userApi.getByToken(TokenProvider.getCurrentToken()).getId());
        this.taskService.setAssignee(taskId, userId);
        return ResponseEntity.ok((Object)"\u8f6c\u6d3e\u6210\u529f!");
    }

    @RequestMapping(value={"/backNodes"})
    public ResponseEntity backNodes(@RequestParam String taskId) {
        List nodes = this.flowTaskService.getBackNodes(taskId);
        return ResponseEntity.ok((Object)nodes);
    }

    @RequestMapping(value={"/back"})
    public ResponseEntity back(String backTaskDefKey, String taskId, TaskComment comment) {
        String procInsId = this.flowTaskService.backTask(backTaskDefKey, taskId, comment);
        return ResponseEntity.ok((Object)procInsId);
    }

    @PostMapping(value={"urge"})
    public ResponseEntity<String> urge(String taskId, String content) {
        ArrayList assignList = Lists.newArrayList();
        this.taskService.getIdentityLinksForTask(taskId).forEach(identityLink -> assignList.add(this.userApi.getById(identityLink.getUserId())));
        this.mailApi.sendEmail((List)assignList, "\u4f60\u6536\u5230\u4e00\u6761\u6d41\u7a0b\u50ac\u529e\u4efb\u52a1!", content + "<p><a href=\"/#/flowable/task/TodoList\" target=\"_blank\">\u70b9\u51fb\u5904\u7406</a><br></p>");
        return ResponseEntity.ok((Object)"\u50ac\u529e\u6210\u529f!");
    }
}

