/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.core.service;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.domain.TreeEntity;
import com.jeeplus.core.domain.TreeMapper;
import com.jeeplus.core.service.TreeService;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.core.service.dto.TreeDTO;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class TreeDTOService<D extends TreeMapper<T>, T extends TreeEntity<T>, DTO extends TreeDTO<DTO>>
extends TreeService<D, T> {
    private static final Logger log = LoggerFactory.getLogger(TreeDTOService.class);
    private Class<DTO> clzzDTO = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[2];

    public List<DTO> treeDataDTO() {
        return this.treeDataDTO(null);
    }

    public abstract List<DTO> listDTO();

    public List<DTO> treeDataDTO(String extId) {
        List<DTO> allList = this.listDTO();
        try {
            TreeDTO root = (TreeDTO)this.clzzDTO.getConstructor(new Class[0]).newInstance(new Object[0]);
            root.setId(TreeDTO.getRootId());
            List<TreeDTO> rootTree = this.formatListToTree((DTO)root, allList, extId);
            return rootTree;
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DTO> formatListToTree(DTO root, List<DTO> allList, String extId) {
        String rootId = ((BaseDTO)root).getId();
        ArrayList trees = Lists.newArrayList();
        HashMap treeMap = Maps.newHashMap();
        for (TreeDTO entity : allList) {
            List entities = (List)treeMap.get(entity.getParentId());
            if (entities == null) {
                entities = Lists.newLinkedList();
            }
            if (!StrUtil.isBlank((CharSequence)extId) && (extId.equals(entity.getId()) || entity.getParentIds().indexOf("," + extId + ",") != -1)) continue;
            entities.add(entity);
            treeMap.put(entity.getParentId(), entities);
        }
        if (treeMap.get(rootId) == null || ((List)treeMap.get(rootId)).isEmpty()) {
            return trees;
        }
        List children = (List)treeMap.get(rootId);
        for (TreeDTO parent : children) {
            this.formatFillChildren(parent, treeMap);
            trees.add(parent);
        }
        if (StrUtil.equals((CharSequence)rootId, (CharSequence)TreeDTO.getRootId())) {
            return children;
        }
        ((TreeDTO)root).setChildren(trees);
        return Lists.newArrayList((Object[])new TreeDTO[]{root});
    }

    private void formatFillChildren(DTO parent, Map<String, List<DTO>> treeMap) {
        List<DTO> children = treeMap.get(((BaseDTO)parent).getId());
        ((TreeDTO)parent).setChildren(children);
        if (children != null && !children.isEmpty()) {
            for (TreeDTO child : children) {
                this.formatFillChildren(child, treeMap);
            }
        }
    }
}

