/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.test.shop.controller;

import com.google.common.collect.Lists;
import com.jeeplus.core.dto.DragNode;
import com.jeeplus.logging.annotation.ApiLog;
import com.jeeplus.test.shop.domain.TestCategory;
import com.jeeplus.test.shop.service.TestCategoryService;
import com.jeeplus.test.shop.service.dto.TestCategoryDTO;
import com.jeeplus.test.shop.service.mapstruct.TestCategoryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7c7b\u578b"})
@RestController
@RequestMapping(value={"/test/shop/testCategory"})
public class TestCategoryController {
    @Autowired
    private TestCategoryService testCategoryService;
    @Autowired
    private TestCategoryWrapper testCategoryWrapper;

    @ApiLog(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u6570\u636e")
    @ApiOperation(value="\u6839\u636eId\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u6570\u636e")
    @PreAuthorize(value="hasAnyAuthority('test:shop:testCategory:view','test:shop:testCategory:add','test:shop:testCategory:edit')")
    @GetMapping(value={"queryById"})
    public ResponseEntity<TestCategoryDTO> queryById(String id) {
        return ResponseEntity.ok((Object)this.testCategoryWrapper.toDTO(this.testCategoryService.getById((Serializable)((Object)id))));
    }

    @ApiLog(value="\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b")
    @ApiOperation(value="\u4fdd\u5b58\u5546\u54c1\u7c7b\u578b")
    @PreAuthorize(value="hasAnyAuthority('test:shop:testCategory:add','test:shop:testCategory:edit')")
    @PostMapping(value={"save"})
    public ResponseEntity<TestCategory> save(@Valid @RequestBody TestCategoryDTO testCategoryDTO) {
        TestCategory testCategory = (TestCategory)this.testCategoryWrapper.toEntity((Object)testCategoryDTO);
        this.testCategoryService.saveOrUpdate(testCategory);
        return ResponseEntity.ok((Object)testCategory);
    }

    @PostMapping(value={"drag"})
    public ResponseEntity drag(@Valid @RequestBody DragNode<TestCategoryDTO> testCategoryDTO) {
        this.testCategoryService.sortList(this.testCategoryWrapper.toEntity(testCategoryDTO));
        return ResponseEntity.ok((Object)"\u79fb\u52a8\u8282\u70b9\u6210\u529f!");
    }

    @ApiLog(value="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ApiOperation(value="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @PreAuthorize(value="hasAuthority('test:shop:testCategory:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity<String> delete(String ids) {
        Object[] idArray = ids.split(",");
        this.testCategoryService.removeWithChildrenByIds((List)Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u5546\u54c1\u7c7b\u578b\u6210\u529f");
    }

    @ApiLog(value="\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u6811\u8868\u6570\u636e")
    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u6811\u8868\u6570\u636e")
    @GetMapping(value={"treeData"})
    public ResponseEntity<List<TestCategoryDTO>> treeData(String extId) {
        List rootTree = this.testCategoryService.treeData(extId).stream().map(arg_0 -> ((TestCategoryWrapper)this.testCategoryWrapper).toDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(rootTree);
    }
}

