/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.sys.feign;

import com.jeeplus.sys.factory.UserApiFallbackFactory;
import com.jeeplus.sys.service.dto.DataRuleDTO;
import com.jeeplus.sys.service.dto.UserDTO;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="userApi", name="jeeplus-system", fallbackFactory=UserApiFallbackFactory.class)
public interface IUserApi {
    public static final String BASE_URL = "/feign/sys/user";

    @GetMapping(value={"/feign/sys/user/getByLoginName"})
    public UserDTO getByLoginName(@RequestParam(value="loginName") String var1, @RequestParam(value="tenantId") String var2);

    @PostMapping(value={"/feign/sys/user/clearCache"})
    public void clearCache(@RequestBody UserDTO var1);

    @PostMapping(value={"/feign/sys/user/getDataRuleList"})
    public List<DataRuleDTO> getDataRuleList(@RequestBody UserDTO var1);

    @PostMapping(value={"/feign/sys/user/updateUser"})
    public void updateUser(@RequestBody UserDTO var1);

    @GetMapping(value={"/feign/sys/user/getPermissions"})
    public Set<String> getPermissions(@RequestParam(value="loginName") String var1);

    @GetMapping(value={"/feign/sys/user/getByToken"})
    public UserDTO getByToken(@RequestParam(value="token") String var1);

    @GetMapping(value={"/feign/sys/user/getById"})
    public UserDTO getById(@RequestParam(value="id") String var1);

    @GetMapping(value={"/feign/sys/user/findListByPostId"})
    public List<UserDTO> findListByPostId(@RequestParam(value="postId") String var1);

    @GetMapping(value={"/feign/sys/user/findListByRoleId"})
    public List<UserDTO> findListByRoleId(@RequestParam(value="roleId") String var1);

    @GetMapping(value={"/feign/sys/user/findListByCompanyId"})
    public List<UserDTO> findListByCompanyId(@RequestParam(value="companyId") String var1);

    @GetMapping(value={"/feign/sys/user/findListByOfficeId"})
    public List<UserDTO> findListByOfficeId(@RequestParam(value="officeId") String var1);

    @GetMapping(value={"/feign/sys/user/isEnableLogin"})
    public boolean isEnableLogin(@RequestParam(value="tenantId") String var1, @RequestParam(value="loginName") String var2);

    @GetMapping(value={"/feign/sys/user/getUserDTOByName"})
    public UserDTO getUserDTOByName(@RequestParam(value="name") String var1);
}

