/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.auth.controller;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.jeeplus.auth.model.LoginForm;
import com.jeeplus.common.SecurityUtils;
import com.jeeplus.common.TokenProvider;
import com.jeeplus.common.redis.RedisUtils;
import com.jeeplus.common.utils.RequestUtils;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.config.properties.JeePlusProperties;
import com.jeeplus.logging.annotation.ApiLog;
import com.jeeplus.logging.constant.enums.LogTypeEnum;
import com.jeeplus.sys.feign.ITenantApi;
import com.jeeplus.sys.feign.IUserApi;
import com.jeeplus.sys.service.dto.UserDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
@RequestMapping(value={"/user"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/login"})
    @ApiLog(value="\u7528\u6237\u767b\u5f55", type=LogTypeEnum.LOGIN)
    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    public ResponseEntity login(@RequestBody LoginForm loginForm) {
        ResponseUtil responseUtil = new ResponseUtil();
        String username = loginForm.getUsername();
        String password = loginForm.getPassword();
        String code = loginForm.getCode();
        if (!code.equals(RedisUtils.getInstance().get("sys:cache:code", loginForm.getUuid()))) {
            return ResponseEntity.badRequest().body((Object)"\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        AuthenticationManager authenticationManager = (AuthenticationManager)SpringUtil.getBean(AuthenticationManager.class);
        SecurityUtils.login((String)username, (String)password, (AuthenticationManager)authenticationManager);
        if (!this.userApi.isEnableLogin(this.tenantApi.getCurrentTenantId(), username)) {
            throw new DisabledException("\u60a8\u7684\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u5730\u65b9\u767b\u5f55\uff0c\u60a8\u88ab\u7981\u6b62\u767b\u5f55\uff01");
        }
        UserDTO userDTO = this.userApi.getByLoginName(username, this.tenantApi.getCurrentTenantId());
        String token = TokenProvider.createAccessToken((String)username);
        responseUtil.add("token", (Object)token);
        this.updateUserLoginInfo(responseUtil, userDTO, token);
        return responseUtil.ok();
    }

    @ApiLog(value="\u5355\u70b9\u767b\u5f55", type=LogTypeEnum.ACCESS)
    @RequestMapping(value={"/casLogin"})
    public ResponseEntity casLogin(@RequestParam(name="ticket") String ticket, @RequestParam(name="service") String service, @Value(value="${cas.server-url-prefix}") String casServer) throws Exception {
        Cas20ServiceTicketValidator ticketValidator = new Cas20ServiceTicketValidator(casServer);
        ResponseUtil responseUtil = new ResponseUtil();
        try {
            Assertion casAssertion = ticketValidator.validate(ticket, service);
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String loginName = casPrincipal.getName();
            UserDTO userDTO = this.userApi.getByLoginName(loginName, this.tenantApi.getCurrentTenantId());
            if (userDTO != null) {
                if ("0".equals(userDTO.getLoginFlag())) {
                    throw new LockedException("\u8be5\u5e10\u53f7\u5df2\u7ecf\u88ab\u7981\u6b62\u767b\u5f55\uff01");
                }
                String token = TokenProvider.createAccessToken((String)userDTO.getLoginName());
                Authentication authentication = TokenProvider.getAuthentication((String)token);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                responseUtil.add("token", (Object)token);
                this.updateUserLoginInfo(responseUtil, userDTO, token);
                return responseUtil.ok();
            }
            UsernameNotFoundException e = new UsernameNotFoundException("\u7528\u6237\u540d\u4e0d\u5b58\u5728!");
            log.error("\u7528\u6237\u3010loginName:" + loginName + "\u3011\u4e0d\u5b58\u5728!", (Throwable)e);
            throw e;
        }
        catch (TicketValidationException e) {
            log.error("Unable to validate ticket [" + ticket + "]", (Throwable)e);
            throw new CredentialsExpiredException("\u672a\u901a\u8fc7\u9a8c\u8bc1\u7684ticket [" + ticket + "]", (Throwable)e);
        }
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @ApiLog(value="\u9000\u51fa\u767b\u5f55", type=LogTypeEnum.LOGIN)
    @GetMapping(value={"/logout"})
    public ResponseEntity logout(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityUtils.getAuthentication();
        if (auth != null) {
            this.userApi.clearCache(SecurityUtils.getCurrentUserDTO());
            String token = TokenProvider.resolveToken((HttpServletRequest)request);
            this.redisUtils.delete("user:cache:token", token);
            this.redisUtils.delete("user:cache:online:users", token);
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return ResponseEntity.ok((Object)"\u9000\u51fa\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @ApiLog(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getCode"})
    public ResponseEntity getCode() {
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha((int)116, (int)36, (int)4, (int)50);
        String uuid = UUID.randomUUID().toString();
        RedisUtils.getInstance().set("sys:cache:code", uuid, (Object)lineCaptcha.getCode());
        RedisUtils.getInstance().expire("sys:cache:code", uuid, 300L);
        return ResponseUtil.newInstance().add("codeImg", (Object)lineCaptcha.getImageBase64()).add("uuid", (Object)uuid).ok();
    }

    private void updateUserLoginInfo(ResponseUtil responseUtil, UserDTO userDTO, String token) {
        userDTO.setLoginDate(new Date());
        userDTO.setLoginIp(ServletUtil.getClientIP((HttpServletRequest)RequestUtils.getRequest(), (String[])new String[0]));
        userDTO.setToken(token);
        this.redisUtils.set("user:cache:token", token, (Object)token);
        this.redisUtils.expire("user:cache:token", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
        this.redisUtils.set("user:cache:online:users", token, (Object)userDTO);
        this.redisUtils.expire("user:cache:online:users", token, JeePlusProperties.newInstance().getEXPIRE_TIME());
        responseUtil.add("oldLoginDate", (Object)userDTO.getLoginDate());
        responseUtil.add("oldLoginIp", (Object)userDTO.getLoginIp());
        this.userApi.updateUser(userDTO);
    }
}

